/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.tag;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import lombok.Generated;
import lombok.NonNull;
import nostr.base.annotation.Key;
import nostr.base.annotation.Tag;
import nostr.event.BaseTag;
import nostr.event.tag.GenericTag;

@Tag(code="t", nip=12)
public class HashtagTag
extends BaseTag {
    @Key
    @JsonProperty(value="t")
    private String hashTag;

    public static <T extends BaseTag> T deserialize(@NonNull JsonNode node) {
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        HashtagTag tag = new HashtagTag();
        HashtagTag.setRequiredField(node.get(1), (n, t) -> tag.setHashTag(n.asText()), tag);
        return (T)tag;
    }

    public static HashtagTag updateFields(@NonNull GenericTag genericTag) {
        if (genericTag == null) {
            throw new NullPointerException("genericTag is marked non-null but is null");
        }
        if (!"t".equals(genericTag.getCode())) {
            throw new IllegalArgumentException("Invalid tag code for HashtagTag");
        }
        if (genericTag.getAttributes().size() != 1) {
            throw new IllegalArgumentException("Invalid number of attributes for HashtagTag");
        }
        HashtagTag tag = new HashtagTag();
        tag.setHashTag(genericTag.getAttributes().get(0).value().toString());
        return tag;
    }

    @Generated
    public static HashtagTagBuilder builder() {
        return new HashtagTagBuilder();
    }

    @Generated
    public String getHashTag() {
        return this.hashTag;
    }

    @JsonProperty(value="t")
    @Generated
    public void setHashTag(String hashTag) {
        this.hashTag = hashTag;
    }

    @Override
    @Generated
    public String toString() {
        return "HashtagTag(hashTag=" + this.getHashTag() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HashtagTag)) {
            return false;
        }
        HashtagTag other = (HashtagTag)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$hashTag = this.getHashTag();
        String other$hashTag = other.getHashTag();
        return !(this$hashTag == null ? other$hashTag != null : !this$hashTag.equals(other$hashTag));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HashtagTag;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $hashTag = this.getHashTag();
        result = result * 59 + ($hashTag == null ? 43 : $hashTag.hashCode());
        return result;
    }

    @Generated
    public HashtagTag() {
    }

    @Generated
    public HashtagTag(String hashTag) {
        this.hashTag = hashTag;
    }

    @Generated
    public static class HashtagTagBuilder {
        @Generated
        private String hashTag;

        @Generated
        HashtagTagBuilder() {
        }

        @JsonProperty(value="t")
        @Generated
        public HashtagTagBuilder hashTag(String hashTag) {
            this.hashTag = hashTag;
            return this;
        }

        @Generated
        public HashtagTag build() {
            return new HashtagTag(this.hashTag);
        }

        @Generated
        public String toString() {
            return "HashtagTag.HashtagTagBuilder(hashTag=" + this.hashTag + ")";
        }
    }
}

