/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.filter;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import nostr.base.IElement;
import nostr.event.filter.Filterable;

public class Filters
implements IElement {
    public static final int DEFAULT_FILTERS_LIMIT = 10;
    private static final String FILTERS_EMPTY_ERROR = "Filters cannot be empty.";
    private static final String FILTER_KEY_ERROR = "Filter key for filterable [%s] is not defined";
    private static final String POSITIVE_LIMIT_ERROR = "Limit must be positive.";
    private final Map<String, List<Filterable>> filtersMap;
    private Integer limit = 10;

    public Filters(Filterable ... filterablesByDefaultType) {
        this(List.of(filterablesByDefaultType));
        if (filterablesByDefaultType == null) {
            throw new NullPointerException("filterablesByDefaultType is marked non-null but is null");
        }
    }

    public Filters(@NonNull List<Filterable> filterablesByDefaultType) {
        this(filterablesByDefaultType.stream().collect(Collectors.groupingBy(Filterable::getFilterKey)));
        if (filterablesByDefaultType == null) {
            throw new NullPointerException("filterablesByDefaultType is marked non-null but is null");
        }
    }

    private Filters(@NonNull Map<String, List<Filterable>> filterablesByCustomType) {
        if (filterablesByCustomType == null) {
            throw new NullPointerException("filterablesByCustomType is marked non-null but is null");
        }
        Filters.validateFiltersMap(filterablesByCustomType);
        this.filtersMap = filterablesByCustomType;
    }

    public List<Filterable> getFilterByType(@NonNull String type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.filtersMap.getOrDefault(type, List.of());
    }

    public void setLimit(@NonNull Integer limit) {
        if (limit == null) {
            throw new NullPointerException("limit is marked non-null but is null");
        }
        if (limit <= 0) {
            throw new IllegalArgumentException(POSITIVE_LIMIT_ERROR);
        }
        this.limit = limit;
    }

    private static void validateFiltersMap(Map<String, List<Filterable>> filtersMap) throws IllegalArgumentException {
        if (filtersMap.isEmpty()) {
            throw new IllegalArgumentException(FILTERS_EMPTY_ERROR);
        }
        filtersMap.values().forEach(filterables -> {
            if (filterables.isEmpty()) {
                throw new IllegalArgumentException(FILTERS_EMPTY_ERROR);
            }
        });
        filtersMap.forEach((key, value) -> {
            String filterKey = Objects.requireNonNullElse(key, "");
            if (filterKey.isEmpty()) {
                throw new IllegalArgumentException(String.format(FILTER_KEY_ERROR, ((Filterable)value.getFirst()).getFilterKey()));
            }
        });
    }

    @Generated
    public Map<String, List<Filterable>> getFiltersMap() {
        return this.filtersMap;
    }

    @Generated
    public Integer getLimit() {
        return this.limit;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Filters)) {
            return false;
        }
        Filters other = (Filters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        Map<String, List<Filterable>> this$filtersMap = this.getFiltersMap();
        Map<String, List<Filterable>> other$filtersMap = other.getFiltersMap();
        return !(this$filtersMap == null ? other$filtersMap != null : !((Object)this$filtersMap).equals(other$filtersMap));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Filters;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        Map<String, List<Filterable>> $filtersMap = this.getFiltersMap();
        result = result * 59 + ($filtersMap == null ? 43 : ((Object)$filtersMap).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Filters(filtersMap=" + String.valueOf(this.getFiltersMap()) + ", limit=" + this.getLimit() + ")";
    }
}

