/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.impl;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import nostr.base.Kind;
import nostr.base.PublicKey;
import nostr.base.annotation.Event;
import nostr.event.BaseTag;
import nostr.event.JsonContent;
import nostr.event.entities.CalendarContent;
import nostr.event.impl.AbstractBaseCalendarEvent;
import nostr.event.json.deserializer.CalendarDateBasedEventDeserializer;
import nostr.event.tag.GenericTag;
import nostr.event.tag.GeohashTag;
import nostr.event.tag.HashtagTag;
import nostr.event.tag.IdentifierTag;
import nostr.event.tag.PubKeyTag;
import nostr.event.tag.ReferenceTag;

@Event(name="Date-Based Calendar Event", nip=52)
@JsonDeserialize(using=CalendarDateBasedEventDeserializer.class)
public class CalendarDateBasedEvent<T extends BaseTag>
extends AbstractBaseCalendarEvent<CalendarContent<T>> {
    public CalendarDateBasedEvent(PublicKey sender, List<BaseTag> baseTags, String content) {
        super(sender, Kind.CALENDAR_DATE_BASED_EVENT, baseTags, content);
    }

    @Override
    public String getId() {
        return ((CalendarContent)this.getCalendarContent()).getIdentifierTag().getUuid();
    }

    public String getTile() {
        return ((CalendarContent)this.getCalendarContent()).getTitle();
    }

    public Date getStart() {
        return new Date(((CalendarContent)this.getCalendarContent()).getStart());
    }

    public Optional<Date> getEnd() {
        JsonContent calendarContent = this.getCalendarContent();
        Optional<Long> end = ((CalendarContent)calendarContent).getEnd();
        return end.map(Date::new);
    }

    public Optional<String> getLocation() {
        return ((CalendarContent)this.getCalendarContent()).getLocation();
    }

    public Optional<String> getGeohash() {
        Optional<GeohashTag> geohashTag = ((CalendarContent)this.getCalendarContent()).getGeohashTag();
        return geohashTag.map(GeohashTag::getLocation);
    }

    public List<PubKeyTag> getParticipants() {
        return ((CalendarContent)this.getCalendarContent()).getParticipantPubKeyTags();
    }

    public List<HashtagTag> getHashtags() {
        return ((CalendarContent)this.getCalendarContent()).getHashtagTags();
    }

    public List<ReferenceTag> getReferences() {
        return ((CalendarContent)this.getCalendarContent()).getReferenceTags();
    }

    @Override
    protected CalendarContent<T> getCalendarContent() {
        CalendarContent calendarContent = new CalendarContent((IdentifierTag)this.getTag("d"), ((GenericTag)this.getTag("title")).getAttributes().get(0).value().toString(), Long.parseLong(((GenericTag)this.getTag("start")).getAttributes().get(0).value().toString()));
        Optional.ofNullable(this.getTag("end")).ifPresent(baseTag -> calendarContent.setEnd(Long.parseLong(((GenericTag)baseTag).getAttributes().get(0).value().toString())));
        Optional.ofNullable(this.getTag("location")).ifPresent(baseTag -> calendarContent.setLocation(((GenericTag)baseTag).getAttributes().get(0).value().toString()));
        Optional.ofNullable(this.getTag("g")).ifPresent(baseTag -> calendarContent.setGeohashTag((GeohashTag)baseTag));
        Optional.ofNullable(this.getTags("p")).ifPresent(baseTags -> baseTags.forEach(baseTag -> calendarContent.addParticipantPubKeyTag((PubKeyTag)baseTag)));
        Optional.ofNullable(this.getTags("t")).ifPresent(baseTags -> baseTags.forEach(baseTag -> calendarContent.addHashtagTag((HashtagTag)baseTag)));
        Optional.ofNullable(this.getTags("r")).ifPresent(baseTags -> baseTags.forEach(baseTag -> calendarContent.addReferenceTag((ReferenceTag)baseTag)));
        return calendarContent;
    }

    @Override
    public void validateKind() {
        if (this.getKind().intValue() != Kind.CALENDAR_DATE_BASED_EVENT.getValue()) {
            throw new AssertionError((Object)("Invalid kind value. Expected " + Kind.CALENDAR_DATE_BASED_EVENT.getValue()));
        }
    }

    @Generated
    public CalendarDateBasedEvent() {
    }
}

