/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.impl;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.List;
import lombok.Generated;
import nostr.base.PublicKey;
import nostr.event.BaseTag;
import nostr.event.entities.NIP15Content;
import nostr.event.impl.DirectMessageEvent;

public abstract class CheckoutEvent<T extends NIP15Content.CheckoutContent>
extends DirectMessageEvent {
    private MessageType messageType;

    public CheckoutEvent(PublicKey sender, List<BaseTag> tags, String content, MessageType messageType) {
        super(sender, tags, content);
        this.messageType = messageType;
    }

    protected abstract T getEntity();

    @Override
    protected void validateContent() {
        super.validateContent();
        try {
            T entity = this.getEntity();
            if (entity == null) {
                throw new AssertionError((Object)"Invalid `content`: Must be a valid CustomerOrder JSON object.");
            }
            if (((NIP15Content.CheckoutContent)entity).getMessageType() != this.messageType) {
                throw new AssertionError((Object)"Invalid `content`: The `messageType` field must match the entity's `messageType`.");
            }
        }
        catch (Exception e) {
            throw new AssertionError("Invalid `content`: Must be a valid CustomerOrder JSON object.", e);
        }
    }

    @Generated
    public MessageType getMessageType() {
        return this.messageType;
    }

    @Generated
    public void setMessageType(MessageType messageType) {
        this.messageType = messageType;
    }

    @Override
    @Generated
    public String toString() {
        return "CheckoutEvent(messageType=" + String.valueOf((Object)this.getMessageType()) + ")";
    }

    @Generated
    public CheckoutEvent() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CheckoutEvent)) {
            return false;
        }
        CheckoutEvent other = (CheckoutEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MessageType this$messageType = this.getMessageType();
        MessageType other$messageType = other.getMessageType();
        return !(this$messageType == null ? other$messageType != null : !((Object)((Object)this$messageType)).equals((Object)other$messageType));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CheckoutEvent;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MessageType $messageType = this.getMessageType();
        result = result * 59 + ($messageType == null ? 43 : ((Object)((Object)$messageType)).hashCode());
        return result;
    }

    public static enum MessageType {
        NEW_ORDER(0, "CustomerOrder"),
        PAYMENT_REQUEST(1, "Merchant"),
        ORDER_STATUS_UPDATE(2, "Merchant");

        private final int value;
        private final String sentBy;

        private MessageType(int value, String sentBy) {
            this.value = value;
            this.sentBy = sentBy;
        }

        @JsonValue
        public int getValue() {
            return this.value;
        }

        @Generated
        public String getSentBy() {
            return this.sentBy;
        }
    }
}

