/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.impl;

import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import nostr.base.IEvent;
import nostr.base.Kind;
import nostr.base.PublicKey;
import nostr.base.annotation.Event;
import nostr.event.BaseTag;
import nostr.event.entities.Product;
import nostr.event.impl.MerchantEvent;

@Event(name="Create Or Update Product Event", nip=15)
public class CreateOrUpdateProductEvent
extends MerchantEvent<Product> {
    public CreateOrUpdateProductEvent(PublicKey sender, List<BaseTag> tags, @NonNull String content) {
        super(sender, 30018, tags, content);
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
    }

    public Product getProduct() {
        return (Product)IEvent.MAPPER_BLACKBIRD.readValue(this.getContent(), Product.class);
    }

    @Override
    protected Product getEntity() {
        return this.getProduct();
    }

    @Override
    public void validateKind() {
        if (this.getKind().intValue() != Kind.PRODUCT_CREATE_OR_UPDATE.getValue()) {
            throw new AssertionError((Object)("Invalid kind value. Expected " + Kind.PRODUCT_CREATE_OR_UPDATE.getValue()));
        }
    }

    @Override
    protected void validateContent() {
        super.validateContent();
        try {
            Product product = this.getProduct();
            if (product.getName() == null || product.getName().isEmpty()) {
                throw new AssertionError((Object)"Invalid `content`: `name` field is required.");
            }
            if (product.getCurrency() == null || product.getCurrency().isEmpty()) {
                throw new AssertionError((Object)"Invalid `content`: `currency` field is required.");
            }
            if (product.getPrice() == null) {
                throw new AssertionError((Object)"Invalid `content`: `price` field is required.");
            }
        }
        catch (Exception e) {
            throw new AssertionError("Invalid `content`: Must be a valid Product JSON object.", e);
        }
    }

    @Generated
    public CreateOrUpdateProductEvent() {
    }
}

