/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.impl;

import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import nostr.base.Kind;
import nostr.base.PublicKey;
import nostr.base.annotation.Event;
import nostr.event.BaseTag;
import nostr.event.NIP04Event;
import nostr.event.tag.PubKeyTag;

@Event(name="Encrypted Direct Message", nip=4)
public class DirectMessageEvent
extends NIP04Event {
    public DirectMessageEvent(PublicKey sender, List<BaseTag> tags, String content) {
        super(sender, Kind.ENCRYPTED_DIRECT_MESSAGE, tags, content);
    }

    public DirectMessageEvent(@NonNull PublicKey sender, @NonNull PublicKey recipient, @NonNull String content) {
        super(sender, Kind.ENCRYPTED_DIRECT_MESSAGE);
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        if (recipient == null) {
            throw new NullPointerException("recipient is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        this.setContent(content);
        this.addTag(PubKeyTag.builder().publicKey(recipient).build());
    }

    @Override
    protected void validateTags() {
        super.validateTags();
        boolean hasRecipientTag = this.getTags().stream().anyMatch(tag -> tag instanceof PubKeyTag);
        if (!hasRecipientTag) {
            throw new AssertionError((Object)"Invalid `tags`: Must include a PubKeyTag for the recipient.");
        }
    }

    @Override
    protected void validateKind() {
        if (this.getKind().intValue() != Kind.ENCRYPTED_DIRECT_MESSAGE.getValue()) {
            throw new AssertionError((Object)("Invalid kind value. Expected " + Kind.ENCRYPTED_DIRECT_MESSAGE.getValue()));
        }
    }

    @Generated
    public DirectMessageEvent() {
    }
}

