/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.tag;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import nostr.base.ElementAttribute;
import nostr.base.IGenericElement;
import nostr.event.BaseTag;
import nostr.event.json.serializer.GenericTagSerializer;

@JsonSerialize(using=GenericTagSerializer.class)
public class GenericTag
extends BaseTag
implements IGenericElement {
    private String code;
    private final List<ElementAttribute> attributes;

    public GenericTag() {
        this("");
    }

    public GenericTag(@NonNull String code) {
        this(code, new ArrayList<ElementAttribute>());
        if (code == null) {
            throw new NullPointerException("code is marked non-null but is null");
        }
    }

    @Deprecated(forRemoval=true)
    public GenericTag(String code, Integer nip) {
        this(code, new ArrayList<ElementAttribute>());
    }

    public GenericTag(@NonNull String code, ElementAttribute ... attribute) {
        this(code, List.of(attribute));
        if (code == null) {
            throw new NullPointerException("code is marked non-null but is null");
        }
        if (attribute == null) {
            throw new NullPointerException("attribute is marked non-null but is null");
        }
    }

    public GenericTag(@NonNull String code, @NonNull List<ElementAttribute> attributes) {
        if (code == null) {
            throw new NullPointerException("code is marked non-null but is null");
        }
        if (attributes == null) {
            throw new NullPointerException("attributes is marked non-null but is null");
        }
        this.code = code;
        this.attributes = attributes;
    }

    @Override
    public String getCode() {
        return "".equals(this.code) ? super.getCode() : this.code;
    }

    public void addAttribute(ElementAttribute ... attribute) {
        if (attribute == null) {
            throw new NullPointerException("attribute is marked non-null but is null");
        }
        this.addAttributes(List.of(attribute));
    }

    public void addAttributes(@NonNull List<ElementAttribute> attributes) {
        if (attributes == null) {
            throw new NullPointerException("attributes is marked non-null but is null");
        }
        this.attributes.addAll(attributes);
    }

    @Generated
    public List<ElementAttribute> getAttributes() {
        return this.attributes;
    }

    @Generated
    public void setCode(String code) {
        this.code = code;
    }

    @Override
    @Generated
    public String toString() {
        return "GenericTag(code=" + this.getCode() + ", attributes=" + String.valueOf(this.getAttributes()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenericTag)) {
            return false;
        }
        GenericTag other = (GenericTag)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        List<ElementAttribute> this$attributes = this.getAttributes();
        List<ElementAttribute> other$attributes = other.getAttributes();
        return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GenericTag;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        List<ElementAttribute> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        return result;
    }
}

