/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.tag;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import lombok.Generated;
import lombok.NonNull;
import nostr.base.annotation.Key;
import nostr.base.annotation.Tag;
import nostr.event.BaseTag;
import nostr.event.tag.GenericTag;
import nostr.event.tag.LabelNamespaceTag;

@Tag(code="l", nip=32)
public class LabelTag
extends BaseTag {
    @Key
    @JsonProperty(value="l")
    private String label;
    @Key
    @JsonProperty(value="L")
    private String nameSpace;

    public LabelTag(@NonNull String label, @NonNull LabelNamespaceTag labelNamespaceTag) {
        this(label, labelNamespaceTag.getNameSpace());
        if (label == null) {
            throw new NullPointerException("label is marked non-null but is null");
        }
        if (labelNamespaceTag == null) {
            throw new NullPointerException("labelNamespaceTag is marked non-null but is null");
        }
    }

    public static <T extends BaseTag> T deserialize(@NonNull JsonNode node) {
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        LabelTag tag = new LabelTag();
        LabelTag.setRequiredField(node.get(1), (n, t) -> tag.setLabel(n.asText()), tag);
        LabelTag.setRequiredField(node.get(2), (n, t) -> tag.setNameSpace(n.asText()), tag);
        return (T)tag;
    }

    public static LabelTag updateFields(@NonNull GenericTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        if (!"l".equals(tag.getCode())) {
            throw new IllegalArgumentException("Invalid tag code for LabelTag");
        }
        LabelTag labelTag = new LabelTag();
        labelTag.setLabel(tag.getAttributes().get(0).value().toString());
        labelTag.setNameSpace(tag.getAttributes().get(1).value().toString());
        return labelTag;
    }

    @Generated
    public String getLabel() {
        return this.label;
    }

    @Generated
    public String getNameSpace() {
        return this.nameSpace;
    }

    @JsonProperty(value="l")
    @Generated
    public void setLabel(String label) {
        this.label = label;
    }

    @JsonProperty(value="L")
    @Generated
    public void setNameSpace(String nameSpace) {
        this.nameSpace = nameSpace;
    }

    @Override
    @Generated
    public String toString() {
        return "LabelTag(label=" + this.getLabel() + ", nameSpace=" + this.getNameSpace() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LabelTag)) {
            return false;
        }
        LabelTag other = (LabelTag)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        String this$nameSpace = this.getNameSpace();
        String other$nameSpace = other.getNameSpace();
        return !(this$nameSpace == null ? other$nameSpace != null : !this$nameSpace.equals(other$nameSpace));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LabelTag;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        String $nameSpace = this.getNameSpace();
        result = result * 59 + ($nameSpace == null ? 43 : $nameSpace.hashCode());
        return result;
    }

    @Generated
    public LabelTag() {
    }

    @Generated
    public LabelTag(String label, String nameSpace) {
        this.label = label;
        this.nameSpace = nameSpace;
    }
}

