/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.filter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import lombok.NonNull;
import nostr.base.IEvent;
import nostr.event.BaseTag;
import nostr.event.impl.GenericEvent;

public interface Filterable {
    public Predicate<GenericEvent> getPredicate();

    public <T> T getFilterable();

    public Object getFilterableValue();

    public String getFilterKey();

    public static <T extends BaseTag> List<T> getTypeSpecificTags(@NonNull Class<T> tagClass, @NonNull GenericEvent event) {
        if (tagClass == null) {
            throw new NullPointerException("tagClass is marked non-null but is null");
        }
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        return event.getTags().stream().filter(tagClass::isInstance).map(tagClass::cast).toList();
    }

    default public ObjectNode toObjectNode(ObjectNode objectNode) {
        ArrayNode arrayNode = IEvent.MAPPER_BLACKBIRD.createArrayNode();
        Optional.ofNullable(objectNode.get(this.getFilterKey())).ifPresent(jsonNode -> jsonNode.elements().forEachRemaining(arg_0 -> ((ArrayNode)arrayNode).add(arg_0)));
        this.addToArrayNode(arrayNode);
        return (ObjectNode)objectNode.set(this.getFilterKey(), (JsonNode)arrayNode);
    }

    default public void addToArrayNode(ArrayNode arrayNode) {
        arrayNode.addAll(IEvent.MAPPER_BLACKBIRD.createArrayNode().add(this.getFilterableValue().toString()));
    }
}

