/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.filter;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.Generated;
import nostr.event.filter.AbstractFilterable;
import nostr.event.filter.Filterable;
import nostr.event.impl.GenericEvent;
import nostr.event.tag.IdentifierTag;

public class IdentifierTagFilter<T extends IdentifierTag>
extends AbstractFilterable<T> {
    public static final String FILTER_KEY = "#d";
    public static Function<JsonNode, Filterable> fxn = node -> new IdentifierTagFilter<IdentifierTag>(new IdentifierTag(node.asText()));

    public IdentifierTagFilter(T identifierTag) {
        super(identifierTag, FILTER_KEY);
    }

    @Override
    public Predicate<GenericEvent> getPredicate() {
        return genericEvent -> Filterable.getTypeSpecificTags(IdentifierTag.class, genericEvent).stream().anyMatch(genericEventIdentifierTag -> genericEventIdentifierTag.getUuid().equals(this.getFilterableValue()));
    }

    @Override
    public String getFilterableValue() {
        return ((IdentifierTag)this.getIdentifierTag()).getUuid();
    }

    private T getIdentifierTag() {
        return (T)((IdentifierTag)super.getFilterable());
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IdentifierTagFilter)) {
            return false;
        }
        IdentifierTagFilter other = (IdentifierTagFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof IdentifierTagFilter;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

