/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.filter;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.Generated;
import nostr.base.PublicKey;
import nostr.event.filter.AbstractFilterable;
import nostr.event.filter.Filterable;
import nostr.event.impl.GenericEvent;
import nostr.event.tag.PubKeyTag;

public class ReferencedPublicKeyFilter<T extends PubKeyTag>
extends AbstractFilterable<T> {
    public static final String FILTER_KEY = "#p";
    public static Function<JsonNode, Filterable> fxn = node -> new ReferencedPublicKeyFilter<PubKeyTag>(new PubKeyTag(new PublicKey(node.asText())));

    public ReferencedPublicKeyFilter(T referencedPubKeyTag) {
        super(referencedPubKeyTag, FILTER_KEY);
    }

    @Override
    public Predicate<GenericEvent> getPredicate() {
        return genericEvent -> Filterable.getTypeSpecificTags(PubKeyTag.class, genericEvent).stream().anyMatch(pubKeyTag -> pubKeyTag.getPublicKey().toHexString().equals(this.getFilterableValue()));
    }

    @Override
    public String getFilterableValue() {
        return ((PubKeyTag)this.getReferencedPublicKey()).getPublicKey().toHexString();
    }

    private T getReferencedPublicKey() {
        return (T)((PubKeyTag)super.getFilterable());
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReferencedPublicKeyFilter)) {
            return false;
        }
        ReferencedPublicKeyFilter other = (ReferencedPublicKeyFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReferencedPublicKeyFilter;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

