/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.impl;

import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import nostr.base.Kind;
import nostr.base.PublicKey;
import nostr.base.Relay;
import nostr.base.annotation.Event;
import nostr.event.BaseTag;
import nostr.event.impl.EphemeralEvent;
import nostr.event.tag.GenericTag;

@Event(name="Canonical authentication event", nip=42)
public class CanonicalAuthenticationEvent
extends EphemeralEvent {
    public CanonicalAuthenticationEvent(@NonNull PublicKey pubKey, @NonNull List<BaseTag> tags, @NonNull String content) {
        super(pubKey, Kind.CLIENT_AUTH, tags, content);
        if (pubKey == null) {
            throw new NullPointerException("pubKey is marked non-null but is null");
        }
        if (tags == null) {
            throw new NullPointerException("tags is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
    }

    public String getChallenge() {
        BaseTag challengeTag = this.getTag("challenge");
        if (challengeTag != null && !((GenericTag)challengeTag).getAttributes().isEmpty()) {
            return ((GenericTag)challengeTag).getAttributes().get(0).value().toString();
        }
        return null;
    }

    public Relay getRelay() {
        BaseTag relayTag = this.getTag("relay");
        if (relayTag != null && !((GenericTag)relayTag).getAttributes().isEmpty()) {
            return new Relay(((GenericTag)relayTag).getAttributes().get(0).value().toString());
        }
        return null;
    }

    @Override
    protected void validateTags() {
        super.validateTags();
        BaseTag challengeTag = this.getTag("challenge");
        if (challengeTag == null || ((GenericTag)challengeTag).getAttributes().isEmpty()) {
            throw new AssertionError((Object)"Missing or invalid `challenge` tag.");
        }
        BaseTag relayTag = this.getTag("relay");
        if (relayTag == null || ((GenericTag)relayTag).getAttributes().isEmpty()) {
            throw new AssertionError((Object)"Missing or invalid `relay` tag.");
        }
    }

    @Override
    public void validateKind() {
        if (this.getKind().intValue() != Kind.CLIENT_AUTH.getValue()) {
            throw new AssertionError((Object)("Invalid kind value. Expected " + Kind.CLIENT_AUTH.getValue()));
        }
    }

    @Generated
    public CanonicalAuthenticationEvent() {
    }
}

