/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.impl;

import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import nostr.base.Kind;
import nostr.base.PublicKey;
import nostr.base.annotation.Event;
import nostr.event.BaseTag;
import nostr.event.impl.GenericEvent;

@Event(name="Contact List and Petnames", nip=2)
public class ContactListEvent
extends GenericEvent {
    public ContactListEvent(@NonNull PublicKey pubKey, @NonNull List<BaseTag> tags) {
        super(pubKey, Kind.CONTACT_LIST, tags);
        if (pubKey == null) {
            throw new NullPointerException("pubKey is marked non-null but is null");
        }
        if (tags == null) {
            throw new NullPointerException("tags is marked non-null but is null");
        }
    }

    @Override
    protected void validateTags() {
        super.validateTags();
        boolean hasPTag = this.getTags().stream().anyMatch(t -> "p".equals(t.getCode()));
        if (!hasPTag) {
            throw new AssertionError((Object)"Missing `p` tag for contact list entries.");
        }
    }

    @Override
    protected void validateKind() {
        if (this.getKind().intValue() != Kind.CONTACT_LIST.getValue()) {
            throw new AssertionError((Object)("Invalid kind value. Expected " + Kind.CONTACT_LIST.getValue()));
        }
    }

    @Override
    @Generated
    public String toString() {
        return "ContactListEvent()";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContactListEvent)) {
            return false;
        }
        ContactListEvent other = (ContactListEvent)o;
        return other.canEqual(this);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ContactListEvent;
    }

    @Override
    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public ContactListEvent() {
    }
}

