/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.impl;

import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import nostr.base.IEvent;
import nostr.base.Kind;
import nostr.base.PublicKey;
import nostr.base.annotation.Event;
import nostr.event.BaseTag;
import nostr.event.entities.PaymentRequest;
import nostr.event.impl.CheckoutEvent;

@Event(name="Merchant Request Payment Event", nip=15)
public class MerchantRequestPaymentEvent
extends CheckoutEvent<PaymentRequest> {
    public MerchantRequestPaymentEvent(PublicKey sender, List<BaseTag> tags, @NonNull String content) {
        super(sender, tags, content, CheckoutEvent.MessageType.PAYMENT_REQUEST);
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
    }

    public PaymentRequest getPaymentRequest() {
        return (PaymentRequest)IEvent.MAPPER_BLACKBIRD.convertValue((Object)this.getContent(), PaymentRequest.class);
    }

    @Override
    protected PaymentRequest getEntity() {
        return this.getPaymentRequest();
    }

    @Override
    public void validateKind() {
        if (this.getKind().intValue() != Kind.ENCRYPTED_DIRECT_MESSAGE.getValue()) {
            throw new AssertionError((Object)("Invalid kind value. Expected " + Kind.ENCRYPTED_DIRECT_MESSAGE.getValue()));
        }
    }

    @Override
    @Generated
    public String toString() {
        return "MerchantRequestPaymentEvent()";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MerchantRequestPaymentEvent)) {
            return false;
        }
        MerchantRequestPaymentEvent other = (MerchantRequestPaymentEvent)o;
        return other.canEqual(this);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MerchantRequestPaymentEvent;
    }

    @Override
    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public MerchantRequestPaymentEvent() {
    }
}

