/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.tag;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import lombok.Generated;
import lombok.NonNull;
import nostr.base.annotation.Key;
import nostr.base.annotation.Tag;
import nostr.event.BaseTag;
import nostr.event.tag.GenericTag;

@Tag(code="emoji", nip=30)
public class EmojiTag
extends BaseTag {
    @Key
    private String shortcode;
    @Key
    @JsonProperty(value="image-url")
    private String url;

    public static <T extends BaseTag> T deserialize(@NonNull JsonNode node) {
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        EmojiTag tag = new EmojiTag();
        EmojiTag.setRequiredField(node.get(1), (n, t) -> tag.setShortcode(n.asText()), tag);
        EmojiTag.setRequiredField(node.get(2), (n, t) -> tag.setUrl(n.asText()), tag);
        return (T)tag;
    }

    public static EmojiTag updateFields(@NonNull GenericTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        if (!"emoji".equals(tag.getCode())) {
            throw new IllegalArgumentException("Invalid tag code for EmojiTag");
        }
        String shortcode = tag.getAttributes().get(0).value().toString();
        String url = tag.getAttributes().get(1).value().toString();
        EmojiTag emojiTag = new EmojiTag(shortcode, url);
        return emojiTag;
    }

    @Generated
    public static EmojiTagBuilder builder() {
        return new EmojiTagBuilder();
    }

    @Generated
    public String getShortcode() {
        return this.shortcode;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public void setShortcode(String shortcode) {
        this.shortcode = shortcode;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    @Generated
    public String toString() {
        return "EmojiTag(shortcode=" + this.getShortcode() + ", url=" + this.getUrl() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EmojiTag)) {
            return false;
        }
        EmojiTag other = (EmojiTag)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$shortcode = this.getShortcode();
        String other$shortcode = other.getShortcode();
        if (this$shortcode == null ? other$shortcode != null : !this$shortcode.equals(other$shortcode)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        return !(this$url == null ? other$url != null : !this$url.equals(other$url));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EmojiTag;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $shortcode = this.getShortcode();
        result = result * 59 + ($shortcode == null ? 43 : $shortcode.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        return result;
    }

    @Generated
    public EmojiTag(String shortcode, String url) {
        this.shortcode = shortcode;
        this.url = url;
    }

    @Generated
    public EmojiTag() {
    }

    @Generated
    public static class EmojiTagBuilder {
        @Generated
        private String shortcode;
        @Generated
        private String url;

        @Generated
        EmojiTagBuilder() {
        }

        @Generated
        public EmojiTagBuilder shortcode(String shortcode) {
            this.shortcode = shortcode;
            return this;
        }

        @JsonProperty(value="image-url")
        @Generated
        public EmojiTagBuilder url(String url) {
            this.url = url;
            return this;
        }

        @Generated
        public EmojiTag build() {
            return new EmojiTag(this.shortcode, this.url);
        }

        @Generated
        public String toString() {
            return "EmojiTag.EmojiTagBuilder(shortcode=" + this.shortcode + ", url=" + this.url + ")";
        }
    }
}

