/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.tag;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonNode;
import java.math.BigDecimal;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import nostr.base.annotation.Key;
import nostr.base.annotation.Tag;
import nostr.event.BaseTag;
import nostr.event.tag.GenericTag;

@Tag(code="price", nip=99)
@JsonPropertyOrder(value={"number", "currency", "frequency"})
public class PriceTag
extends BaseTag {
    @Key
    @JsonProperty
    @JsonFormat(shape=JsonFormat.Shape.STRING)
    private BigDecimal number;
    @Key
    @JsonProperty
    private String currency;
    @Key
    @JsonProperty
    private String frequency;

    public static <T extends BaseTag> T deserialize(@NonNull JsonNode node) {
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        PriceTag tag = new PriceTag();
        PriceTag.setRequiredField(node.get(1), (n, t) -> tag.setNumber(new BigDecimal(n.asText())), tag);
        PriceTag.setOptionalField(node.get(2), (n, t) -> tag.setCurrency(n.asText()), tag);
        PriceTag.setOptionalField(node.get(3), (n, t) -> tag.setFrequency(n.asText()), tag);
        return (T)tag;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PriceTag priceTag = (PriceTag)o;
        return Objects.equals(this.number.stripTrailingZeros(), priceTag.number.stripTrailingZeros()) && Objects.equals(this.currency, priceTag.currency) && Objects.equals(this.frequency, priceTag.frequency);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.number.stripTrailingZeros(), this.currency, this.frequency);
    }

    public static PriceTag updateFields(@NonNull GenericTag genericTag) {
        if (genericTag == null) {
            throw new NullPointerException("genericTag is marked non-null but is null");
        }
        if (!"price".equals(genericTag.getCode())) {
            throw new IllegalArgumentException("Invalid tag code for PriceTag");
        }
        if (genericTag.getAttributes().size() < 2 || genericTag.getAttributes().size() > 3) {
            throw new IllegalArgumentException("Invalid number of attributes for PriceTag");
        }
        PriceTag tag = new PriceTag();
        tag.setNumber(new BigDecimal(genericTag.getAttributes().get(0).value().toString()));
        tag.setCurrency(genericTag.getAttributes().get(1).value().toString());
        if (genericTag.getAttributes().size() > 2) {
            tag.setFrequency(genericTag.getAttributes().get(2).value().toString());
        }
        return tag;
    }

    @Generated
    public static PriceTagBuilder builder() {
        return new PriceTagBuilder();
    }

    @Generated
    public BigDecimal getNumber() {
        return this.number;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public String getFrequency() {
        return this.frequency;
    }

    @Generated
    public void setNumber(BigDecimal number) {
        this.number = number;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setFrequency(String frequency) {
        this.frequency = frequency;
    }

    @Override
    @Generated
    public String toString() {
        return "PriceTag(number=" + String.valueOf(this.getNumber()) + ", currency=" + this.getCurrency() + ", frequency=" + this.getFrequency() + ")";
    }

    @Generated
    public PriceTag() {
    }

    @Generated
    public PriceTag(BigDecimal number, String currency, String frequency) {
        this.number = number;
        this.currency = currency;
        this.frequency = frequency;
    }

    @Generated
    public static class PriceTagBuilder {
        @Generated
        private BigDecimal number;
        @Generated
        private String currency;
        @Generated
        private String frequency;

        @Generated
        PriceTagBuilder() {
        }

        @JsonProperty
        @JsonFormat(shape=JsonFormat.Shape.STRING)
        @Generated
        public PriceTagBuilder number(BigDecimal number) {
            this.number = number;
            return this;
        }

        @JsonProperty
        @Generated
        public PriceTagBuilder currency(String currency) {
            this.currency = currency;
            return this;
        }

        @JsonProperty
        @Generated
        public PriceTagBuilder frequency(String frequency) {
            this.frequency = frequency;
            return this;
        }

        @Generated
        public PriceTag build() {
            return new PriceTag(this.number, this.currency, this.frequency);
        }

        @Generated
        public String toString() {
            return "PriceTag.PriceTagBuilder(number=" + String.valueOf(this.number) + ", currency=" + this.currency + ", frequency=" + this.frequency + ")";
        }
    }
}

