/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.tag;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonNode;
import lombok.Generated;
import lombok.NonNull;
import nostr.base.PublicKey;
import nostr.base.annotation.Key;
import nostr.base.annotation.Tag;
import nostr.event.BaseTag;
import nostr.event.tag.GenericTag;

@JsonPropertyOrder(value={"pubKey", "mainRelayUrl", "petName"})
@Tag(code="p")
public class PubKeyTag
extends BaseTag {
    @Key
    @JsonProperty(value="publicKey")
    private PublicKey publicKey;
    @Key
    @JsonProperty(value="mainRelayUrl")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String mainRelayUrl;
    @Key(nip=2)
    @JsonProperty(value="petName")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String petName;

    public PubKeyTag(@NonNull PublicKey publicKey) {
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        this.publicKey = publicKey;
    }

    public PubKeyTag(@NonNull PublicKey publicKey, String mainRelayUrl, String petName) {
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        this.publicKey = publicKey;
        this.mainRelayUrl = mainRelayUrl;
        this.petName = petName;
    }

    public static <T extends BaseTag> T deserialize(@NonNull JsonNode node) {
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        PubKeyTag tag = new PubKeyTag();
        PubKeyTag.setRequiredField(node.get(1), (n, t) -> tag.setPublicKey(new PublicKey(n.asText())), tag);
        PubKeyTag.setOptionalField(node.get(2), (n, t) -> tag.setMainRelayUrl(n.asText()), tag);
        PubKeyTag.setOptionalField(node.get(3), (n, t) -> tag.setPetName(n.asText()), tag);
        return (T)tag;
    }

    public static PubKeyTag updateFields(@NonNull GenericTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        if (!"p".equals(tag.getCode())) {
            throw new IllegalArgumentException("Invalid tag code for PubKeyTag");
        }
        PublicKey pubKey = new PublicKey(tag.getAttributes().get(0).value().toString());
        String mainRelayUrl = tag.getAttributes().size() > 1 ? tag.getAttributes().get(1).value().toString() : null;
        String petName = tag.getAttributes().size() > 2 ? tag.getAttributes().get(2).value().toString() : null;
        PubKeyTag pubKeyTag = new PubKeyTag(pubKey, mainRelayUrl, petName);
        return pubKeyTag;
    }

    @Generated
    public static PubKeyTagBuilder builder() {
        return new PubKeyTagBuilder();
    }

    @Generated
    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    @Generated
    public String getMainRelayUrl() {
        return this.mainRelayUrl;
    }

    @Generated
    public String getPetName() {
        return this.petName;
    }

    @Generated
    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    @Generated
    public void setMainRelayUrl(String mainRelayUrl) {
        this.mainRelayUrl = mainRelayUrl;
    }

    @Generated
    public void setPetName(String petName) {
        this.petName = petName;
    }

    @Override
    @Generated
    public String toString() {
        return "PubKeyTag(publicKey=" + String.valueOf(this.getPublicKey()) + ", mainRelayUrl=" + this.getMainRelayUrl() + ", petName=" + this.getPetName() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PubKeyTag)) {
            return false;
        }
        PubKeyTag other = (PubKeyTag)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PublicKey this$publicKey = this.getPublicKey();
        PublicKey other$publicKey = other.getPublicKey();
        if (this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey)) {
            return false;
        }
        String this$mainRelayUrl = this.getMainRelayUrl();
        String other$mainRelayUrl = other.getMainRelayUrl();
        if (this$mainRelayUrl == null ? other$mainRelayUrl != null : !this$mainRelayUrl.equals(other$mainRelayUrl)) {
            return false;
        }
        String this$petName = this.getPetName();
        String other$petName = other.getPetName();
        return !(this$petName == null ? other$petName != null : !this$petName.equals(other$petName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PubKeyTag;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        PublicKey $publicKey = this.getPublicKey();
        result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
        String $mainRelayUrl = this.getMainRelayUrl();
        result = result * 59 + ($mainRelayUrl == null ? 43 : $mainRelayUrl.hashCode());
        String $petName = this.getPetName();
        result = result * 59 + ($petName == null ? 43 : $petName.hashCode());
        return result;
    }

    @Generated
    public PubKeyTag() {
    }

    @Generated
    public static class PubKeyTagBuilder {
        @Generated
        private PublicKey publicKey;
        @Generated
        private String mainRelayUrl;
        @Generated
        private String petName;

        @Generated
        PubKeyTagBuilder() {
        }

        @JsonProperty(value="publicKey")
        @Generated
        public PubKeyTagBuilder publicKey(PublicKey publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        @JsonProperty(value="mainRelayUrl")
        @Generated
        public PubKeyTagBuilder mainRelayUrl(String mainRelayUrl) {
            this.mainRelayUrl = mainRelayUrl;
            return this;
        }

        @JsonProperty(value="petName")
        @Generated
        public PubKeyTagBuilder petName(String petName) {
            this.petName = petName;
            return this;
        }

        @Generated
        public PubKeyTag build() {
            return new PubKeyTag(this.publicKey, this.mainRelayUrl, this.petName);
        }

        @Generated
        public String toString() {
            return "PubKeyTag.PubKeyTagBuilder(publicKey=" + String.valueOf(this.publicKey) + ", mainRelayUrl=" + this.mainRelayUrl + ", petName=" + this.petName + ")";
        }
    }
}

