/*
 * Decompiled with CFR 0.152.
 */
package nostr.event;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import lombok.NonNull;
import nostr.base.ElementAttribute;
import nostr.base.IEvent;
import nostr.base.ITag;
import nostr.base.annotation.Key;
import nostr.base.annotation.Tag;
import nostr.event.json.deserializer.TagDeserializer;
import nostr.event.json.serializer.BaseTagSerializer;
import nostr.event.tag.GenericTag;
import nostr.event.tag.TagRegistry;
import org.apache.commons.lang3.stream.Streams;

@JsonDeserialize(using=TagDeserializer.class)
@JsonSerialize(using=BaseTagSerializer.class)
public abstract class BaseTag
implements ITag {
    public void setParent(IEvent event) {
    }

    public String getCode() {
        return this.getClass().getAnnotation(Tag.class).code();
    }

    public Optional<String> getFieldValue(Field field) {
        try {
            return Optional.ofNullable(new PropertyDescriptor(field.getName(), this.getClass()).getReadMethod().invoke((Object)this, new Object[0])).map(Object::toString);
        }
        catch (IntrospectionException | IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            return Optional.empty();
        }
    }

    public List<Field> getSupportedFields() {
        return (List)Streams.failableStream(Arrays.stream(this.getClass().getDeclaredFields())).filter(f -> Objects.nonNull(f.getAnnotation(Key.class))).filter(f -> this.getFieldValue((Field)f).isPresent()).collect(Collectors.toList());
    }

    public static BaseTag create(@NonNull String code, String ... params) {
        if (code == null) {
            throw new NullPointerException("code is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        return BaseTag.create(code, List.of(params));
    }

    public static BaseTag create(@NonNull String code, @NonNull List<String> params) {
        if (code == null) {
            throw new NullPointerException("code is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        GenericTag genericTag = new GenericTag(code, IntStream.range(0, params.size()).mapToObj(i -> new ElementAttribute("param".concat(String.valueOf(i)), params.get(i))).toList());
        return Optional.ofNullable(TagRegistry.get(code)).map(f -> (BaseTag)f.apply(genericTag)).orElse(genericTag);
    }

    protected static <T extends BaseTag> void setOptionalField(JsonNode node, BiConsumer<JsonNode, T> con, T tag) {
        Optional.ofNullable(node).ifPresent(n -> con.accept((JsonNode)n, tag));
    }

    protected static <T extends BaseTag> void setRequiredField(JsonNode node, BiConsumer<JsonNode, T> con, T tag) {
        con.accept(Optional.ofNullable(node).orElseThrow(), (JsonNode)tag);
    }

    @Generated
    public BaseTag() {
    }

    @Generated
    public String toString() {
        return "BaseTag()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseTag)) {
            return false;
        }
        BaseTag other = (BaseTag)o;
        return other.canEqual(this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BaseTag;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

