/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.entities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.net.URL;
import lombok.Generated;
import lombok.NonNull;
import nostr.base.IBech32Encodable;
import nostr.base.PublicKey;
import nostr.base.json.EventJsonMapper;
import nostr.crypto.bech32.Bech32;
import nostr.crypto.bech32.Bech32Prefix;
import nostr.event.entities.Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UserProfile
extends Profile
implements IBech32Encodable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserProfile.class);
    @JsonIgnore
    private PublicKey publicKey;
    private String nip05;

    public UserProfile(@NonNull PublicKey publicKey, String name, String nip05, String about, URL picture) {
        super(name, about, picture);
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        this.publicKey = publicKey;
        this.nip05 = nip05;
    }

    public String toBech32() {
        try {
            return Bech32.encode((Bech32.Encoding)Bech32.Encoding.BECH32, (String)Bech32Prefix.NPROFILE.getCode(), (byte[])this.publicKey.getRawData());
        }
        catch (Exception ex) {
            log.error("Failed to convert UserProfile to Bech32 format", (Throwable)ex);
            throw new RuntimeException("Failed to convert UserProfile to Bech32 format", ex);
        }
    }

    @Override
    public String toString() {
        try {
            return EventJsonMapper.mapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Generated
    protected UserProfile(UserProfileBuilder<?, ?> b) {
        super(b);
        this.publicKey = b.publicKey;
        this.nip05 = b.nip05;
    }

    @Generated
    public static UserProfileBuilder<?, ?> builder() {
        return new UserProfileBuilderImpl();
    }

    @Generated
    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    @Generated
    public String getNip05() {
        return this.nip05;
    }

    @Generated
    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    @Generated
    public void setNip05(String nip05) {
        this.nip05 = nip05;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserProfile)) {
            return false;
        }
        UserProfile other = (UserProfile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PublicKey this$publicKey = this.getPublicKey();
        PublicKey other$publicKey = other.getPublicKey();
        if (this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey)) {
            return false;
        }
        String this$nip05 = this.getNip05();
        String other$nip05 = other.getNip05();
        return !(this$nip05 == null ? other$nip05 != null : !this$nip05.equals(other$nip05));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UserProfile;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PublicKey $publicKey = this.getPublicKey();
        result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
        String $nip05 = this.getNip05();
        result = result * 59 + ($nip05 == null ? 43 : $nip05.hashCode());
        return result;
    }

    @Generated
    public UserProfile() {
    }

    @Generated
    public static abstract class UserProfileBuilder<C extends UserProfile, B extends UserProfileBuilder<C, B>>
    extends Profile.ProfileBuilder<C, B> {
        @Generated
        private PublicKey publicKey;
        @Generated
        private String nip05;

        @JsonIgnore
        @Generated
        public B publicKey(PublicKey publicKey) {
            this.publicKey = publicKey;
            return (B)this.self();
        }

        @Generated
        public B nip05(String nip05) {
            this.nip05 = nip05;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "UserProfile.UserProfileBuilder(super=" + super.toString() + ", publicKey=" + String.valueOf(this.publicKey) + ", nip05=" + this.nip05 + ")";
        }
    }

    @Generated
    private static final class UserProfileBuilderImpl
    extends UserProfileBuilder<UserProfile, UserProfileBuilderImpl> {
        @Generated
        private UserProfileBuilderImpl() {
        }

        @Override
        @Generated
        protected UserProfileBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public UserProfile build() {
            return new UserProfile(this);
        }
    }
}

