/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.filter;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import nostr.base.PublicKey;
import nostr.base.Relay;
import nostr.event.filter.AbstractFilterable;
import nostr.event.filter.Filterable;
import nostr.event.impl.GenericEvent;
import nostr.event.tag.AddressTag;
import nostr.event.tag.IdentifierTag;

public class AddressTagFilter<T extends AddressTag>
extends AbstractFilterable<T> {
    public static final String FILTER_KEY = "#a";
    public static Function<JsonNode, Filterable> fxn = node -> new AddressTagFilter<AddressTag>(AddressTagFilter.createAddressTag(node));

    public AddressTagFilter(T addressableTag) {
        super(addressableTag, FILTER_KEY);
    }

    @Override
    public Predicate<GenericEvent> getPredicate() {
        return genericEvent -> Filterable.getTypeSpecificTags(AddressTag.class, genericEvent).stream().anyMatch(addressTag -> addressTag.equals(this.getAddressableTag()));
    }

    @Override
    public Object getFilterableValue() {
        String requiredAttributes = Stream.of(((AddressTag)this.getAddressableTag()).getKind(), ((AddressTag)this.getAddressableTag()).getPublicKey().toHexString(), ((AddressTag)this.getAddressableTag()).getIdentifierTag().getUuid()).map(rec$ -> rec$.toString()).collect(Collectors.joining(":"));
        return Optional.ofNullable(((AddressTag)this.getAddressableTag()).getRelay()).map(relay -> String.join((CharSequence)"\",\"", requiredAttributes, relay.getUri())).orElse(requiredAttributes);
    }

    private T getAddressableTag() {
        return (T)((AddressTag)super.getFilterable());
    }

    protected static AddressTag createAddressTag(@NonNull JsonNode node) {
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        String[] nodes = node.asText().split(",");
        List<String> list = Arrays.stream(nodes[0].split(":")).toList();
        AddressTag addressTag = new AddressTag();
        addressTag.setKind(Integer.valueOf(list.get(0)));
        addressTag.setPublicKey(new PublicKey(list.get(1)));
        addressTag.setIdentifierTag(new IdentifierTag(list.get(2)));
        if (!Objects.equals(2, nodes.length)) {
            return addressTag;
        }
        addressTag.setIdentifierTag(new IdentifierTag(list.get(2).replaceAll("\"$", "")));
        addressTag.setRelay(new Relay(nodes[1].replaceAll("^\"", "")));
        return addressTag;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddressTagFilter)) {
            return false;
        }
        AddressTagFilter other = (AddressTagFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AddressTagFilter;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

