/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.filter;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.Generated;
import nostr.event.filter.AbstractFilterable;
import nostr.event.filter.Filterable;
import nostr.event.impl.GenericEvent;
import nostr.event.tag.GeohashTag;

public class GeohashTagFilter<T extends GeohashTag>
extends AbstractFilterable<T> {
    public static final String FILTER_KEY = "#g";
    public static Function<JsonNode, Filterable> fxn = node -> new GeohashTagFilter<GeohashTag>(new GeohashTag(node.asText()));

    public GeohashTagFilter(T geohashTag) {
        super(geohashTag, FILTER_KEY);
    }

    @Override
    public Predicate<GenericEvent> getPredicate() {
        return genericEvent -> Filterable.getTypeSpecificTags(GeohashTag.class, genericEvent).stream().anyMatch(geoHashTag -> geoHashTag.getLocation().equals(this.getFilterableValue()));
    }

    @Override
    public String getFilterableValue() {
        return ((GeohashTag)this.getGeoHashTag()).getLocation();
    }

    private T getGeoHashTag() {
        return (T)((GeohashTag)super.getFilterable());
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeohashTagFilter)) {
            return false;
        }
        GeohashTagFilter other = (GeohashTagFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GeohashTagFilter;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

