/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.filter;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.Generated;
import nostr.event.filter.AbstractFilterable;
import nostr.event.filter.Filterable;
import nostr.event.impl.GenericEvent;
import nostr.event.tag.EventTag;

public class ReferencedEventFilter<T extends EventTag>
extends AbstractFilterable<T> {
    public static final String FILTER_KEY = "#e";
    public static Function<JsonNode, Filterable> fxn = node -> new ReferencedEventFilter<EventTag>(new EventTag(node.asText()));

    public ReferencedEventFilter(T referencedEventTag) {
        super(referencedEventTag, FILTER_KEY);
    }

    @Override
    public Predicate<GenericEvent> getPredicate() {
        return genericEvent -> Filterable.getTypeSpecificTags(EventTag.class, genericEvent).stream().anyMatch(eventTag -> eventTag.getIdEvent().equals(this.getFilterableValue()));
    }

    @Override
    public String getFilterableValue() {
        return ((EventTag)this.getReferencedEventTag()).getIdEvent();
    }

    private T getReferencedEventTag() {
        return (T)((EventTag)super.getFilterable());
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReferencedEventFilter)) {
            return false;
        }
        ReferencedEventFilter other = (ReferencedEventFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReferencedEventFilter;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

