/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.filter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.Generated;
import nostr.base.json.EventJsonMapper;
import nostr.event.filter.AbstractFilterable;
import nostr.event.filter.Filterable;
import nostr.event.impl.GenericEvent;

public class UntilFilter
extends AbstractFilterable<Long> {
    public static final String FILTER_KEY = "until";
    public static Function<JsonNode, List<Filterable>> fxn = node -> List.of(new UntilFilter(node.asLong()));

    public UntilFilter(Long until) {
        super(until, FILTER_KEY);
    }

    @Override
    public Predicate<GenericEvent> getPredicate() {
        return genericEvent -> genericEvent.getCreatedAt() < this.getUntil();
    }

    @Override
    public ObjectNode toObjectNode(ObjectNode objectNode) {
        return EventJsonMapper.mapper().createObjectNode().put(FILTER_KEY, this.getUntil());
    }

    @Override
    public String getFilterableValue() {
        return this.getUntil().toString();
    }

    private Long getUntil() {
        return (Long)super.getFilterable();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UntilFilter)) {
            return false;
        }
        UntilFilter other = (UntilFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UntilFilter;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

