/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.impl;

import java.util.List;
import lombok.Generated;
import nostr.base.PublicKey;
import nostr.base.annotation.Event;
import nostr.event.BaseTag;
import nostr.event.NIP01Event;

@Event(name="Addressable Events")
public class AddressableEvent
extends NIP01Event {
    public AddressableEvent(PublicKey pubKey, Integer kind, List<BaseTag> tags, String content) {
        super(pubKey, kind, tags, content);
    }

    @Override
    public void validateKind() {
        super.validateKind();
        Integer n = this.getKind();
        if (n >= 30000 && n < 40000) {
            return;
        }
        throw new AssertionError(String.format("Invalid kind value %d. Addressable events must be in range [30000, 40000).", n), null);
    }

    @Override
    @Generated
    public String toString() {
        return "AddressableEvent()";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddressableEvent)) {
            return false;
        }
        AddressableEvent other = (AddressableEvent)o;
        return other.canEqual(this);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AddressableEvent;
    }

    @Override
    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public AddressableEvent() {
    }
}

