/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.impl;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import nostr.base.Kind;
import nostr.base.PublicKey;
import nostr.base.annotation.Event;
import nostr.event.BaseTag;
import nostr.event.JsonContent;
import nostr.event.entities.CalendarContent;
import nostr.event.filter.Filterable;
import nostr.event.impl.AbstractBaseCalendarEvent;
import nostr.event.json.deserializer.CalendarEventDeserializer;
import nostr.event.tag.AddressTag;
import nostr.event.tag.GenericTag;
import nostr.event.tag.IdentifierTag;

@Event(name="Calendar Event", nip=52)
@JsonDeserialize(using=CalendarEventDeserializer.class)
public class CalendarEvent
extends AbstractBaseCalendarEvent<JsonContent> {
    public CalendarEvent(@NonNull PublicKey sender, @NonNull List<BaseTag> baseTags, @NonNull String content) {
        super(sender, Kind.CALENDAR_EVENT, baseTags, content);
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        if (baseTags == null) {
            throw new NullPointerException("baseTags is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
    }

    @Override
    public String getId() {
        return ((CalendarContent)this.getCalendarContent()).getIdentifierTag().getUuid();
    }

    public String getTitle() {
        return ((CalendarContent)this.getCalendarContent()).getTitle();
    }

    public List<String> getCalendarEventIds() {
        return ((CalendarContent)this.getCalendarContent()).getAddressTags().stream().map(tag -> tag.getIdentifierTag().getUuid()).toList();
    }

    public List<PublicKey> getCalendarEventAuthors() {
        return ((CalendarContent)this.getCalendarContent()).getAddressTags().stream().map(AddressTag::getPublicKey).toList();
    }

    @Override
    protected CalendarContent<BaseTag> getCalendarContent() {
        IdentifierTag idTag = Filterable.requireTagOfTypeWithCode(IdentifierTag.class, "d", this);
        String title = Filterable.requireTagOfTypeWithCode(GenericTag.class, "title", this).getAttributes().get(0).value().toString();
        CalendarContent<BaseTag> calendarContent = new CalendarContent<BaseTag>(idTag, title, -1L);
        Filterable.getTypeSpecificTags(AddressTag.class, this).forEach(calendarContent::addAddressTag);
        return calendarContent;
    }

    @Override
    protected void validateTags() {
        super.validateTags();
        if (Filterable.firstTagOfTypeWithCode(IdentifierTag.class, "d", this).isEmpty()) {
            throw new AssertionError((Object)"Missing `d` tag for the event identifier.");
        }
        if (Filterable.firstTagOfTypeWithCode(GenericTag.class, "title", this).isEmpty()) {
            throw new AssertionError((Object)"Missing `title` tag for the event title.");
        }
    }

    @Override
    public void validateKind() {
        if (this.getKind().intValue() != Kind.CALENDAR_EVENT.getValue()) {
            throw new AssertionError((Object)("Invalid kind value. Expected " + Kind.CALENDAR_EVENT.getValue()));
        }
    }

    @Generated
    public CalendarEvent() {
    }
}

