/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.impl;

import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import nostr.base.Kind;
import nostr.base.PublicKey;
import nostr.base.Relay;
import nostr.base.annotation.Event;
import nostr.event.BaseTag;
import nostr.event.filter.Filterable;
import nostr.event.impl.EphemeralEvent;
import nostr.event.tag.GenericTag;

@Event(name="Canonical authentication event", nip=42)
public class CanonicalAuthenticationEvent
extends EphemeralEvent {
    public CanonicalAuthenticationEvent(@NonNull PublicKey pubKey, @NonNull List<BaseTag> tags, @NonNull String content) {
        super(pubKey, Kind.CLIENT_AUTH, tags, content);
        if (pubKey == null) {
            throw new NullPointerException("pubKey is marked non-null but is null");
        }
        if (tags == null) {
            throw new NullPointerException("tags is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
    }

    public String getChallenge() {
        return Filterable.firstTagOfTypeWithCode(GenericTag.class, "challenge", this).filter(tag -> !tag.getAttributes().isEmpty()).map(tag -> tag.getAttributes().get(0).value().toString()).orElse(null);
    }

    public Relay getRelay() {
        return Filterable.firstTagOfTypeWithCode(GenericTag.class, "relay", this).filter(tag -> !tag.getAttributes().isEmpty()).map(tag -> new Relay(tag.getAttributes().get(0).value().toString())).orElse(null);
    }

    @Override
    protected void validateTags() {
        super.validateTags();
        Filterable.firstTagOfTypeWithCode(GenericTag.class, "challenge", this).filter(tag -> !tag.getAttributes().isEmpty()).orElseThrow(() -> new AssertionError((Object)"Missing or invalid `challenge` tag."));
        Filterable.firstTagOfTypeWithCode(GenericTag.class, "relay", this).filter(tag -> !tag.getAttributes().isEmpty()).orElseThrow(() -> new AssertionError((Object)"Missing or invalid `relay` tag."));
    }

    @Override
    public void validateKind() {
        if (this.getKind().intValue() != Kind.CLIENT_AUTH.getValue()) {
            throw new AssertionError((Object)("Invalid kind value. Expected " + Kind.CLIENT_AUTH.getValue()));
        }
    }

    @Generated
    public CanonicalAuthenticationEvent() {
    }
}

