/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import lombok.Generated;
import nostr.base.Kind;
import nostr.base.PublicKey;
import nostr.base.annotation.Event;
import nostr.base.json.EventJsonMapper;
import nostr.event.BaseTag;
import nostr.event.entities.ChannelProfile;
import nostr.event.impl.GenericEvent;
import nostr.event.json.codec.EventEncodingException;

@Event(name="Create Channel", nip=28)
public class ChannelCreateEvent
extends GenericEvent {
    public ChannelCreateEvent(PublicKey pubKey, String content) {
        super(pubKey, Kind.CHANNEL_CREATE, new ArrayList<BaseTag>(), content);
    }

    public ChannelProfile getChannelProfile() {
        String content = this.getContent();
        try {
            return (ChannelProfile)EventJsonMapper.mapper().readValue(content, ChannelProfile.class);
        }
        catch (JsonProcessingException ex) {
            throw new EventEncodingException("Failed to parse channel profile content", (Throwable)ex);
        }
    }

    @Override
    protected void validateKind() {
        if (this.getKind().intValue() != Kind.CHANNEL_CREATE.getValue()) {
            throw new AssertionError((Object)("Invalid kind value. Expected " + Kind.CHANNEL_CREATE.getValue()));
        }
    }

    @Override
    protected void validateContent() {
        super.validateContent();
        try {
            ChannelProfile profile = this.getChannelProfile();
            if (profile.getName() == null || profile.getName().isEmpty()) {
                throw new AssertionError((Object)"Invalid `content`: `name` field is required.");
            }
            if (profile.getAbout() == null || profile.getAbout().isEmpty()) {
                throw new AssertionError((Object)"Invalid `content`: `about` field is required.");
            }
            if (profile.getPicture() == null) {
                throw new AssertionError((Object)"Invalid `content`: `picture` field is required.");
            }
        }
        catch (EventEncodingException e) {
            throw new AssertionError("Invalid `content`: Must be a valid ChannelProfile JSON object.", e);
        }
    }

    @Generated
    public ChannelCreateEvent() {
    }
}

