/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import nostr.base.Kind;
import nostr.base.Marker;
import nostr.base.PublicKey;
import nostr.base.Relay;
import nostr.base.annotation.Event;
import nostr.event.BaseTag;
import nostr.event.filter.Filterable;
import nostr.event.impl.ChannelCreateEvent;
import nostr.event.impl.GenericEvent;
import nostr.event.tag.EventTag;

@Event(name="Channel Message", nip=28)
public class ChannelMessageEvent
extends GenericEvent {
    public ChannelMessageEvent(PublicKey pubKey, List<BaseTag> baseTags, String content) {
        super(pubKey, Kind.CHANNEL_MESSAGE, baseTags, content);
    }

    public String getChannelCreateEventId() {
        return Filterable.getTypeSpecificTags(EventTag.class, this).stream().filter(tag -> tag.getMarkerOptional().filter(m -> m == Marker.ROOT).isPresent()).map(EventTag::getIdEvent).findFirst().orElseThrow();
    }

    public String getChannelMessageReplyEventId() {
        return Filterable.getTypeSpecificTags(EventTag.class, this).stream().filter(tag -> tag.getMarkerOptional().filter(m -> m == Marker.REPLY).isPresent()).map(EventTag::getIdEvent).findFirst().orElse(null);
    }

    public Relay getRootRecommendedRelay() {
        return Filterable.getTypeSpecificTags(EventTag.class, this).stream().filter(tag -> tag.getMarkerOptional().filter(m -> m == Marker.ROOT).isPresent()).map(EventTag::getRecommendedRelayUrlOptional).flatMap(Optional::stream).map(Relay::new).findFirst().orElse(null);
    }

    public Relay getReplyRecommendedRelay(@NonNull String eventId) {
        if (eventId == null) {
            throw new NullPointerException("eventId is marked non-null but is null");
        }
        return Filterable.getTypeSpecificTags(EventTag.class, this).stream().filter(tag -> tag.getMarkerOptional().filter(m -> m == Marker.REPLY).isPresent() && tag.getIdEvent().equals(eventId)).map(EventTag::getRecommendedRelayUrlOptional).flatMap(Optional::stream).map(Relay::new).findFirst().orElse(null);
    }

    @Override
    public void validate() {
        super.validate();
        EventTag rootTag = Filterable.getTypeSpecificTags(EventTag.class, this).stream().filter(tag -> tag.getMarkerOptional().filter(m -> m == Marker.ROOT).isPresent()).findFirst().orElseThrow(() -> new AssertionError((Object)"Missing or invalid `e` root tag."));
    }

    public ChannelMessageEvent(@NonNull PublicKey pubKey, @NonNull ChannelCreateEvent rootEvent, String content, Relay recommendedRelay) {
        super(pubKey, Kind.CHANNEL_MESSAGE, new ArrayList<BaseTag>(), content);
        if (pubKey == null) {
            throw new NullPointerException("pubKey is marked non-null but is null");
        }
        if (rootEvent == null) {
            throw new NullPointerException("rootEvent is marked non-null but is null");
        }
        EventTag eventTag = EventTag.builder().idEvent(rootEvent.getId()).marker(Marker.ROOT).build();
        if (recommendedRelay != null) {
            eventTag.setRecommendedRelayUrl(recommendedRelay.getUri());
        }
        this.addTag(eventTag);
    }

    public ChannelMessageEvent(@NonNull PublicKey pubKey, @NonNull ChannelCreateEvent rootEvent, @NonNull ChannelMessageEvent replyEvent, String content) {
        super(pubKey, Kind.CHANNEL_MESSAGE, new ArrayList<BaseTag>(), content);
        if (pubKey == null) {
            throw new NullPointerException("pubKey is marked non-null but is null");
        }
        if (rootEvent == null) {
            throw new NullPointerException("rootEvent is marked non-null but is null");
        }
        if (replyEvent == null) {
            throw new NullPointerException("replyEvent is marked non-null but is null");
        }
        this.addTag(EventTag.builder().idEvent(rootEvent.getId()).marker(Marker.ROOT).build());
        this.addTag(EventTag.builder().idEvent(replyEvent.getId()).marker(Marker.REPLY).build());
    }

    public ChannelMessageEvent(@NonNull PublicKey pubKey, @NonNull ChannelCreateEvent rootEvent, @NonNull ChannelMessageEvent replyEvent, String content, Relay recommendedRelay) {
        this(pubKey, rootEvent, replyEvent, content, recommendedRelay, recommendedRelay);
        if (pubKey == null) {
            throw new NullPointerException("pubKey is marked non-null but is null");
        }
        if (rootEvent == null) {
            throw new NullPointerException("rootEvent is marked non-null but is null");
        }
        if (replyEvent == null) {
            throw new NullPointerException("replyEvent is marked non-null but is null");
        }
    }

    public ChannelMessageEvent(@NonNull PublicKey pubKey, ChannelCreateEvent rootEvent, ChannelMessageEvent replyEvent, String content, Relay recommendedRelayRoot, Relay recommendedRelayReply) {
        super(pubKey, Kind.CHANNEL_MESSAGE, new ArrayList<BaseTag>(), content);
        if (pubKey == null) {
            throw new NullPointerException("pubKey is marked non-null but is null");
        }
        EventTag rootEventTag = EventTag.builder().idEvent(rootEvent.getId()).marker(Marker.ROOT).build();
        if (recommendedRelayRoot != null) {
            rootEventTag.setRecommendedRelayUrl(recommendedRelayRoot.getUri());
        }
        this.addTag(rootEventTag);
        EventTag replyEventTag = EventTag.builder().idEvent(replyEvent.getId()).marker(Marker.REPLY).build();
        if (recommendedRelayReply != null) {
            replyEventTag.setRecommendedRelayUrl(recommendedRelayReply.getUri());
        }
        this.addTag(replyEventTag);
    }

    @Override
    protected void validateKind() {
        if (this.getKind().intValue() != Kind.CHANNEL_MESSAGE.getValue()) {
            throw new AssertionError((Object)("Invalid kind value. Expected " + Kind.CHANNEL_MESSAGE.getValue()));
        }
    }

    @Generated
    public ChannelMessageEvent() {
    }
}

