/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.impl;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.Instant;
import java.util.List;
import java.util.NoSuchElementException;
import lombok.Generated;
import nostr.base.Kind;
import nostr.base.PublicKey;
import nostr.base.annotation.Event;
import nostr.event.BaseTag;
import nostr.event.NIP99Event;
import nostr.event.filter.Filterable;
import nostr.event.json.deserializer.ClassifiedListingEventDeserializer;
import nostr.event.tag.GenericTag;
import nostr.event.tag.PriceTag;

@Event(name="ClassifiedListingEvent", nip=99)
@JsonDeserialize(using=ClassifiedListingEventDeserializer.class)
public class ClassifiedListingEvent
extends NIP99Event {
    public ClassifiedListingEvent(PublicKey pubKey, Kind kind, List<BaseTag> tags, String content) {
        super(pubKey, kind, tags, content);
    }

    public Instant getPublishedAt() {
        GenericTag tag = Filterable.requireTagOfTypeWithCode(GenericTag.class, "published_at", this);
        return Instant.ofEpochSecond(Long.parseLong(tag.getAttributes().get(0).value().toString()));
    }

    public String getLocation() {
        return Filterable.requireTagOfTypeWithCode(GenericTag.class, "location", this).getAttributes().get(0).value().toString();
    }

    public String getTitle() {
        return Filterable.requireTagOfTypeWithCode(GenericTag.class, "title", this).getAttributes().get(0).value().toString();
    }

    public String getSummary() {
        return Filterable.requireTagOfTypeWithCode(GenericTag.class, "summary", this).getAttributes().get(0).value().toString();
    }

    public String getImage() {
        return Filterable.requireTagOfTypeWithCode(GenericTag.class, "image", this).getAttributes().get(0).value().toString();
    }

    public Status getStatus() {
        String status = Filterable.requireTagOfTypeWithCode(GenericTag.class, "status", this).getAttributes().get(0).value().toString();
        return Status.valueOf(status);
    }

    public String getPrice() {
        PriceTag priceTag = (PriceTag)this.getTags().stream().filter(tag -> tag instanceof PriceTag).findFirst().orElseThrow();
        return priceTag.getNumber().toString() + " " + priceTag.getCurrency() + priceTag.getFrequencyOptional().map(f -> " " + f).orElse("");
    }

    @Override
    protected void validateTags() {
        super.validateTags();
        try {
            Long.parseLong(Filterable.requireTagOfTypeWithCode(GenericTag.class, "published_at", this).getAttributes().get(0).value().toString());
        }
        catch (NoSuchElementException e) {
            throw new AssertionError((Object)"Missing `published_at` tag for the publication date/time.");
        }
        catch (NumberFormatException e) {
            throw new AssertionError((Object)"Invalid `published_at` tag value: must be a numeric timestamp.");
        }
        if (Filterable.firstTagOfTypeWithCode(GenericTag.class, "location", this).isEmpty()) {
            throw new AssertionError((Object)"Missing `location` tag for the listing location.");
        }
        if (Filterable.firstTagOfTypeWithCode(GenericTag.class, "title", this).isEmpty()) {
            throw new AssertionError((Object)"Missing `title` tag for the listing title.");
        }
        if (Filterable.firstTagOfTypeWithCode(GenericTag.class, "summary", this).isEmpty()) {
            throw new AssertionError((Object)"Missing `summary` tag for the listing summary.");
        }
        if (Filterable.firstTagOfTypeWithCode(GenericTag.class, "image", this).isEmpty()) {
            throw new AssertionError((Object)"Missing `image` tag for the listing image.");
        }
        if (Filterable.firstTagOfTypeWithCode(GenericTag.class, "status", this).isEmpty()) {
            throw new AssertionError((Object)"Missing `status` tag for the listing status.");
        }
    }

    @Override
    public void validateKind() {
        Integer n = this.getKind();
        if (n.intValue() == Kind.CLASSIFIED_LISTING.getValue() || n.intValue() == Kind.CLASSIFIED_LISTING_INACTIVE.getValue()) {
            return;
        }
        throw new AssertionError(String.format("Invalid kind value [%s]. Classified Listing must be either %d or %d", n, Kind.CLASSIFIED_LISTING.getValue(), Kind.CLASSIFIED_LISTING_INACTIVE.getValue()), null);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassifiedListingEvent)) {
            return false;
        }
        ClassifiedListingEvent other = (ClassifiedListingEvent)o;
        return other.canEqual(this);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClassifiedListingEvent;
    }

    @Override
    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public ClassifiedListingEvent() {
    }

    public static enum Status {
        ACTIVE("active"),
        SOLD("sold");

        private final String value;

        private Status(String value) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            this.value = value;
        }

        @Generated
        public String getValue() {
            return this.value;
        }
    }
}

