/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.impl;

import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import nostr.base.Kind;
import nostr.base.PublicKey;
import nostr.base.annotation.Event;
import nostr.event.BaseTag;
import nostr.event.entities.ZapReceipt;
import nostr.event.filter.Filterable;
import nostr.event.impl.GenericEvent;
import nostr.event.tag.GenericTag;
import nostr.event.tag.PubKeyTag;

@Event(name="ZapReceiptEvent", nip=57)
public class ZapReceiptEvent
extends GenericEvent {
    public ZapReceiptEvent(@NonNull PublicKey recipientPubKey, @NonNull List<BaseTag> tags, @NonNull String content) {
        super(recipientPubKey, Kind.ZAP_RECEIPT, tags, content);
        if (recipientPubKey == null) {
            throw new NullPointerException("recipientPubKey is marked non-null but is null");
        }
        if (tags == null) {
            throw new NullPointerException("tags is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
    }

    public ZapReceipt getZapReceipt() {
        String bolt11 = Filterable.requireTagOfTypeWithCode(GenericTag.class, "bolt11", this).getAttributes().get(0).value().toString();
        String description = Filterable.requireTagOfTypeWithCode(GenericTag.class, "description", this).getAttributes().get(0).value().toString();
        String preimage = Filterable.requireTagOfTypeWithCode(GenericTag.class, "preimage", this).getAttributes().get(0).value().toString();
        return new ZapReceipt(bolt11, description, preimage);
    }

    public String getBolt11() {
        ZapReceipt zapReceipt = this.getZapReceipt();
        return zapReceipt.getBolt11();
    }

    public String getDescriptionSha256() {
        ZapReceipt zapReceipt = this.getZapReceipt();
        return zapReceipt.getDescriptionSha256();
    }

    public String getPreimage() {
        ZapReceipt zapReceipt = this.getZapReceipt();
        return zapReceipt.getPreimage();
    }

    public PublicKey getRecipient() {
        PubKeyTag recipientPubKeyTag = Filterable.requireTagOfTypeWithCode(PubKeyTag.class, "p", this);
        return recipientPubKeyTag.getPublicKey();
    }

    public PublicKey getSender() {
        return Filterable.firstTagOfTypeWithCode(PubKeyTag.class, "P", this).map(PubKeyTag::getPublicKey).orElse(null);
    }

    public String getEventId() {
        return Filterable.firstTagOfTypeWithCode(GenericTag.class, "e", this).map(tag -> tag.getAttributes().get(0).value().toString()).orElse(null);
    }

    @Override
    protected void validateTags() {
        super.validateTags();
        Filterable.requireTagOfTypeWithCode(PubKeyTag.class, "p", this);
        Filterable.requireTagOfTypeWithCode(GenericTag.class, "bolt11", this);
        Filterable.requireTagOfTypeWithCode(GenericTag.class, "description", this);
        Filterable.requireTagOfTypeWithCode(GenericTag.class, "preimage", this);
    }

    @Override
    protected void validateKind() {
        if (this.getKind().intValue() != Kind.ZAP_RECEIPT.getValue()) {
            throw new AssertionError((Object)("Invalid kind value. Expected " + Kind.ZAP_RECEIPT.getValue()));
        }
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ZapReceiptEvent)) {
            return false;
        }
        ZapReceiptEvent other = (ZapReceiptEvent)o;
        return other.canEqual(this);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ZapReceiptEvent;
    }

    @Override
    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public ZapReceiptEvent() {
    }
}

