/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.json.codec;

import com.fasterxml.jackson.core.JsonProcessingException;
import lombok.Generated;
import nostr.base.Encoder;
import nostr.event.BaseEvent;
import nostr.event.json.EventJsonMapper;
import nostr.event.json.codec.EventEncodingException;

public class BaseEventEncoder<T extends BaseEvent>
implements Encoder {
    private final T event;

    public BaseEventEncoder(T event) {
        this.event = event;
    }

    public String encode() throws EventEncodingException {
        try {
            return EventJsonMapper.getMapper().writeValueAsString(this.event);
        }
        catch (JsonProcessingException e) {
            throw new EventEncodingException("Failed to encode event to JSON", (Throwable)e);
        }
    }

    @Generated
    public T getEvent() {
        return this.event;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseEventEncoder)) {
            return false;
        }
        BaseEventEncoder other = (BaseEventEncoder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        T this$event = this.getEvent();
        T other$event = other.getEvent();
        return !(this$event == null ? other$event != null : !this$event.equals(other$event));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BaseEventEncoder;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        T $event = this.getEvent();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BaseEventEncoder(event=" + String.valueOf(this.getEvent()) + ")";
    }
}

