/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.json.codec;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import java.util.function.Function;
import java.util.stream.StreamSupport;
import lombok.NonNull;
import nostr.event.filter.AddressTagFilter;
import nostr.event.filter.AuthorFilter;
import nostr.event.filter.EventFilter;
import nostr.event.filter.Filterable;
import nostr.event.filter.GenericTagQueryFilter;
import nostr.event.filter.GeohashTagFilter;
import nostr.event.filter.HashtagTagFilter;
import nostr.event.filter.IdentifierTagFilter;
import nostr.event.filter.KindFilter;
import nostr.event.filter.ReferencedEventFilter;
import nostr.event.filter.ReferencedPublicKeyFilter;
import nostr.event.filter.SinceFilter;
import nostr.event.filter.UntilFilter;
import nostr.event.filter.VoteTagFilter;

public class FilterableProvider {
    protected static List<Filterable> getFilterFunction(@NonNull JsonNode node, @NonNull String type) {
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return switch (type) {
            case "#p" -> FilterableProvider.getFilterable(node, ReferencedPublicKeyFilter.fxn);
            case "#e" -> FilterableProvider.getFilterable(node, ReferencedEventFilter.fxn);
            case "#d" -> FilterableProvider.getFilterable(node, IdentifierTagFilter.fxn);
            case "#a" -> FilterableProvider.getFilterable(node, AddressTagFilter.fxn);
            case "#g" -> FilterableProvider.getFilterable(node, GeohashTagFilter.fxn);
            case "#t" -> FilterableProvider.getFilterable(node, HashtagTagFilter.fxn);
            case "#v" -> FilterableProvider.getFilterable(node, VoteTagFilter.fxn);
            case "authors" -> FilterableProvider.getFilterable(node, AuthorFilter.fxn);
            case "ids" -> FilterableProvider.getFilterable(node, EventFilter.fxn);
            case "kinds" -> FilterableProvider.getFilterable(node, KindFilter.fxn);
            case "since" -> SinceFilter.fxn.apply(node);
            case "until" -> UntilFilter.fxn.apply(node);
            default -> FilterableProvider.getFilterable(node, GenericTagQueryFilter.fxn(type));
        };
    }

    private static List<Filterable> getFilterable(JsonNode jsonNode, Function<JsonNode, Filterable> filterFunction) {
        return StreamSupport.stream(jsonNode.spliterator(), false).map(filterFunction).toList();
    }
}

