/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.json.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import nostr.base.json.EventJsonMapper;
import nostr.event.impl.CalendarEvent;
import nostr.event.impl.GenericEvent;
import nostr.util.NostrException;

public class CalendarEventDeserializer
extends StdDeserializer<CalendarEvent> {
    public CalendarEventDeserializer() {
        super(CalendarEvent.class);
    }

    public CalendarEvent deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        JsonNode calendarEventNode = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        GenericEvent genericEvent = (GenericEvent)EventJsonMapper.mapper().treeToValue((TreeNode)calendarEventNode, GenericEvent.class);
        try {
            return GenericEvent.convert(genericEvent, CalendarEvent.class);
        }
        catch (NostrException ex) {
            throw new IOException("Failed to convert generic event into CalendarEvent", ex);
        }
    }
}

