/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.json.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.StreamSupport;
import nostr.base.Kind;
import nostr.base.PublicKey;
import nostr.base.Signature;
import nostr.base.json.EventJsonMapper;
import nostr.event.BaseTag;
import nostr.event.impl.ClassifiedListingEvent;

public class ClassifiedListingEventDeserializer
extends StdDeserializer<ClassifiedListingEvent> {
    public ClassifiedListingEventDeserializer() {
        super(ClassifiedListingEvent.class);
    }

    public ClassifiedListingEvent deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        JsonNode classifiedListingEventNode = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        ArrayNode tags = (ArrayNode)classifiedListingEventNode.get("tags");
        List<BaseTag> baseTags = StreamSupport.stream(tags.spliterator(), false).toList().stream().map(JsonNode::elements).map(element -> (BaseTag)EventJsonMapper.mapper().convertValue(element, BaseTag.class)).toList();
        HashMap<String, String> generalMap = new HashMap<String, String>();
        Iterator fieldNames = classifiedListingEventNode.fieldNames();
        while (fieldNames.hasNext()) {
            String key = (String)fieldNames.next();
            generalMap.put(key, classifiedListingEventNode.get(key).asText());
        }
        ClassifiedListingEvent classifiedListingEvent = new ClassifiedListingEvent(new PublicKey((String)generalMap.get("pubkey")), Kind.valueOf((int)Integer.parseInt((String)generalMap.get("kind"))), baseTags, (String)generalMap.get("content"));
        classifiedListingEvent.setId((String)generalMap.get("id"));
        classifiedListingEvent.setCreatedAt(Long.valueOf((String)generalMap.get("created_at")));
        classifiedListingEvent.setSignature(Signature.fromString((String)((String)generalMap.get("sig"))));
        return classifiedListingEvent;
    }
}

