/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.message;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import nostr.base.Command;
import nostr.base.IDecoder;
import nostr.event.BaseMessage;
import nostr.event.BaseTag;
import nostr.event.impl.CanonicalAuthenticationEvent;
import nostr.event.impl.GenericEvent;
import nostr.event.json.EventJsonMapper;
import nostr.event.json.codec.BaseEventEncoder;
import nostr.event.json.codec.EventEncodingException;
import nostr.event.message.BaseAuthMessage;
import nostr.event.tag.GenericTag;

public class CanonicalAuthenticationMessage
extends BaseAuthMessage {
    @JsonProperty
    private final CanonicalAuthenticationEvent event;

    public CanonicalAuthenticationMessage(CanonicalAuthenticationEvent event) {
        super(Command.AUTH.name());
        this.event = event;
    }

    @Override
    public String encode() throws EventEncodingException {
        try {
            return EventJsonMapper.getMapper().writeValueAsString((Object)JsonNodeFactory.instance.arrayNode().add(this.getCommand()).add(EventJsonMapper.getMapper().readTree(new BaseEventEncoder<CanonicalAuthenticationEvent>(this.getEvent()).encode())));
        }
        catch (JsonProcessingException e) {
            throw new EventEncodingException("Failed to encode canonical authentication message", (Throwable)e);
        }
    }

    public static <T extends BaseMessage> T decode(@NonNull Map<String, Object> map) {
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        try {
            GenericEvent event = (GenericEvent)IDecoder.I_DECODER_MAPPER_BLACKBIRD.convertValue(map, (TypeReference)new TypeReference<GenericEvent>(){});
            List<BaseTag> baseTags = event.getTags().stream().filter(GenericTag.class::isInstance).toList();
            CanonicalAuthenticationEvent canonEvent = new CanonicalAuthenticationEvent(event.getPubKey(), baseTags, "");
            canonEvent.setId(String.valueOf(map.get("id")));
            CanonicalAuthenticationMessage result = new CanonicalAuthenticationMessage(canonEvent);
            return (T)result;
        }
        catch (IllegalArgumentException ex) {
            throw new EventEncodingException("Failed to decode canonical authentication message", (Throwable)ex);
        }
    }

    @Generated
    public CanonicalAuthenticationEvent getEvent() {
        return this.event;
    }
}

