/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.serializer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.List;
import lombok.NonNull;
import nostr.base.PublicKey;
import nostr.event.BaseTag;
import nostr.event.json.EventJsonMapper;
import nostr.util.NostrException;
import nostr.util.NostrUtil;

public final class EventSerializer {
    private static final ObjectMapper MAPPER = EventJsonMapper.getMapper();

    private EventSerializer() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static String serialize(@NonNull PublicKey pubKey, @NonNull Long createdAt, @NonNull Integer kind, @NonNull List<BaseTag> tags, @NonNull String content) throws NostrException {
        if (pubKey == null) {
            throw new NullPointerException("pubKey is marked non-null but is null");
        }
        if (createdAt == null) {
            throw new NullPointerException("createdAt is marked non-null but is null");
        }
        if (kind == null) {
            throw new NullPointerException("kind is marked non-null but is null");
        }
        if (tags == null) {
            throw new NullPointerException("tags is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        ArrayNode arrayNode = JsonNodeFactory.instance.arrayNode();
        try {
            arrayNode.add(0);
            arrayNode.add(pubKey.toString());
            arrayNode.add(createdAt);
            arrayNode.add(kind);
            arrayNode.add(MAPPER.valueToTree(tags));
            arrayNode.add(content);
            return MAPPER.writeValueAsString((Object)arrayNode);
        }
        catch (JsonProcessingException e) {
            throw new NostrException("Failed to serialize event: " + e.getMessage(), (Throwable)e);
        }
    }

    public static byte[] serializeToBytes(@NonNull PublicKey pubKey, @NonNull Long createdAt, @NonNull Integer kind, @NonNull List<BaseTag> tags, @NonNull String content) throws NostrException {
        if (pubKey == null) {
            throw new NullPointerException("pubKey is marked non-null but is null");
        }
        if (createdAt == null) {
            throw new NullPointerException("createdAt is marked non-null but is null");
        }
        if (kind == null) {
            throw new NullPointerException("kind is marked non-null but is null");
        }
        if (tags == null) {
            throw new NullPointerException("tags is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        return EventSerializer.serialize(pubKey, createdAt, kind, tags, content).getBytes(StandardCharsets.UTF_8);
    }

    public static String computeEventId(byte[] serializedEvent) throws NostrException {
        try {
            return NostrUtil.bytesToHex((byte[])NostrUtil.sha256((byte[])serializedEvent));
        }
        catch (NoSuchAlgorithmException e) {
            throw new NostrException("SHA-256 algorithm not available", (Throwable)e);
        }
    }

    public static String serializeAndComputeId(@NonNull PublicKey pubKey, Long createdAt, @NonNull Integer kind, @NonNull List<BaseTag> tags, @NonNull String content) throws NostrException {
        if (pubKey == null) {
            throw new NullPointerException("pubKey is marked non-null but is null");
        }
        if (kind == null) {
            throw new NullPointerException("kind is marked non-null but is null");
        }
        if (tags == null) {
            throw new NullPointerException("tags is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        Long timestamp = createdAt != null ? createdAt.longValue() : Instant.now().getEpochSecond();
        byte[] serialized = EventSerializer.serializeToBytes(pubKey, timestamp, kind, tags, content);
        return EventSerializer.computeEventId(serialized);
    }
}

