/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.support;

import java.lang.reflect.InvocationTargetException;
import lombok.NonNull;
import nostr.event.impl.GenericEvent;
import nostr.util.NostrException;

public final class GenericEventConverter {
    private GenericEventConverter() {
    }

    public static <T extends GenericEvent> T convert(@NonNull GenericEvent source, @NonNull Class<T> target) throws NostrException {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        try {
            GenericEvent event = (GenericEvent)target.getConstructor(new Class[0]).newInstance(new Object[0]);
            event.setContent(source.getContent());
            event.setTags(source.getTags());
            event.setPubKey(source.getPubKey());
            event.setId(source.getId());
            event.setSerializedEventCache(source.getSerializedEventCache());
            event.setNip(source.getNip());
            event.setKind(source.getKind());
            event.setSignature(source.getSignature());
            event.setCreatedAt(source.getCreatedAt());
            return (T)event;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new NostrException("Failed to convert GenericEvent", (Throwable)e);
        }
    }
}

