/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.support;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import nostr.event.impl.GenericEvent;
import nostr.event.json.EventJsonMapper;
import nostr.util.NostrException;

public final class GenericEventSerializer {
    private GenericEventSerializer() {
    }

    public static String serialize(GenericEvent event) throws NostrException {
        ObjectMapper mapper = EventJsonMapper.getMapper();
        ArrayNode arrayNode = JsonNodeFactory.instance.arrayNode();
        try {
            arrayNode.add(0);
            arrayNode.add(event.getPubKey().toString());
            arrayNode.add(event.getCreatedAt());
            arrayNode.add(event.getKind());
            arrayNode.add(mapper.valueToTree(event.getTags()));
            arrayNode.add(event.getContent());
            return mapper.writeValueAsString((Object)arrayNode);
        }
        catch (JsonProcessingException e) {
            throw new NostrException(e.getMessage());
        }
    }
}

