/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.support;

import java.util.List;
import java.util.Objects;
import lombok.NonNull;
import nostr.event.BaseTag;
import nostr.event.impl.GenericEvent;
import nostr.util.validator.HexStringValidator;

public final class GenericEventValidator {
    private GenericEventValidator() {
    }

    public static void validate(@NonNull GenericEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        GenericEventValidator.requireHex(event.getId(), 64, "Missing required `id` field.");
        GenericEventValidator.requireHex(event.getPubKey() != null ? event.getPubKey().toString() : null, 64, "Missing required `pubkey` field.");
        GenericEventValidator.requireHex(event.getSignature() != null ? event.getSignature().toString() : null, 128, "Missing required `sig` field.");
        if (event.getCreatedAt() == null || event.getCreatedAt() < 0L) {
            throw new AssertionError((Object)"Invalid `created_at`: Must be a non-negative integer.");
        }
        GenericEventValidator.validateKind(event.getKind());
        GenericEventValidator.validateTags(event.getTags());
        GenericEventValidator.validateContent(event.getContent());
    }

    private static void requireHex(String value, int length, String missingMessage) {
        Objects.requireNonNull(value, missingMessage);
        HexStringValidator.validateHex((String)value, (int)length);
    }

    public static void validateKind(Integer kind) {
        if (kind == null || kind < 0) {
            throw new AssertionError((Object)"Invalid `kind`: Must be a non-negative integer.");
        }
    }

    public static void validateTags(List<BaseTag> tags) {
        if (tags == null) {
            throw new AssertionError((Object)"Invalid `tags`: Must be a non-null array.");
        }
    }

    public static void validateContent(String content) {
        if (content == null) {
            throw new AssertionError((Object)"Invalid `content`: Must be a string.");
        }
    }
}

