/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.tag;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import nostr.base.ElementAttribute;
import nostr.base.PublicKey;
import nostr.base.Relay;
import nostr.base.annotation.Tag;
import nostr.event.BaseTag;
import nostr.event.json.serializer.AddressTagSerializer;
import nostr.event.tag.GenericTag;
import nostr.event.tag.IdentifierTag;

@Tag(code="a", nip=33)
@JsonSerialize(using=AddressTagSerializer.class)
public class AddressTag
extends BaseTag {
    private Integer kind;
    private PublicKey publicKey;
    private IdentifierTag identifierTag;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Relay relay;

    public Optional<Relay> getRelayOptional() {
        return Optional.ofNullable(this.relay);
    }

    public Optional<IdentifierTag> getIdentifierTagOptional() {
        return Optional.ofNullable(this.identifierTag);
    }

    public static AddressTag deserialize(@NonNull JsonNode node) {
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        AddressTag tag = new AddressTag();
        String[] parts = node.get(1).asText().split(":");
        tag.setKind(Integer.valueOf(parts[0]));
        tag.setPublicKey(new PublicKey(parts[1]));
        if (parts.length == 3) {
            tag.setIdentifierTag(new IdentifierTag(parts[2]));
        }
        if (node.size() == 3) {
            tag.setRelay(new Relay(node.get(2).asText()));
        }
        return tag;
    }

    public static AddressTag updateFields(@NonNull GenericTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        if (!"a".equals(tag.getCode())) {
            throw new IllegalArgumentException("Invalid tag code for AddressTag");
        }
        AddressTag addressTag = new AddressTag();
        List<ElementAttribute> attributes = tag.getAttributes();
        String attr0 = attributes.get(0).value().toString();
        String[] parts = attr0.split(":");
        Integer kind = Integer.parseInt(parts[0]);
        PublicKey publicKey = new PublicKey(parts[1]);
        String id = parts.length == 3 ? parts[2] : null;
        addressTag.setKind(kind);
        addressTag.setPublicKey(publicKey);
        addressTag.setIdentifierTag(id != null ? new IdentifierTag(id) : null);
        if (tag.getAttributes().size() == 2) {
            addressTag.setRelay(new Relay(tag.getAttributes().get(1).value().toString()));
        }
        return addressTag;
    }

    @Generated
    public static AddressTagBuilder builder() {
        return new AddressTagBuilder();
    }

    @Generated
    public Integer getKind() {
        return this.kind;
    }

    @Generated
    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    @Generated
    public IdentifierTag getIdentifierTag() {
        return this.identifierTag;
    }

    @Generated
    public Relay getRelay() {
        return this.relay;
    }

    @Generated
    public void setKind(Integer kind) {
        this.kind = kind;
    }

    @Generated
    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    @Generated
    public void setIdentifierTag(IdentifierTag identifierTag) {
        this.identifierTag = identifierTag;
    }

    @Generated
    public void setRelay(Relay relay) {
        this.relay = relay;
    }

    @Override
    @Generated
    public String toString() {
        return "AddressTag(kind=" + this.getKind() + ", publicKey=" + String.valueOf(this.getPublicKey()) + ", identifierTag=" + String.valueOf(this.getIdentifierTag()) + ", relay=" + String.valueOf(this.getRelay()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddressTag)) {
            return false;
        }
        AddressTag other = (AddressTag)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$kind = this.getKind();
        Integer other$kind = other.getKind();
        if (this$kind == null ? other$kind != null : !((Object)this$kind).equals(other$kind)) {
            return false;
        }
        PublicKey this$publicKey = this.getPublicKey();
        PublicKey other$publicKey = other.getPublicKey();
        if (this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey)) {
            return false;
        }
        IdentifierTag this$identifierTag = this.getIdentifierTag();
        IdentifierTag other$identifierTag = other.getIdentifierTag();
        if (this$identifierTag == null ? other$identifierTag != null : !((Object)this$identifierTag).equals(other$identifierTag)) {
            return false;
        }
        Relay this$relay = this.getRelay();
        Relay other$relay = other.getRelay();
        return !(this$relay == null ? other$relay != null : !this$relay.equals(other$relay));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AddressTag;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $kind = this.getKind();
        result = result * 59 + ($kind == null ? 43 : ((Object)$kind).hashCode());
        PublicKey $publicKey = this.getPublicKey();
        result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
        IdentifierTag $identifierTag = this.getIdentifierTag();
        result = result * 59 + ($identifierTag == null ? 43 : ((Object)$identifierTag).hashCode());
        Relay $relay = this.getRelay();
        result = result * 59 + ($relay == null ? 43 : $relay.hashCode());
        return result;
    }

    @Generated
    public AddressTag() {
    }

    @Generated
    public AddressTag(Integer kind, PublicKey publicKey, IdentifierTag identifierTag, Relay relay) {
        this.kind = kind;
        this.publicKey = publicKey;
        this.identifierTag = identifierTag;
        this.relay = relay;
    }

    @Generated
    public static class AddressTagBuilder {
        @Generated
        private Integer kind;
        @Generated
        private PublicKey publicKey;
        @Generated
        private IdentifierTag identifierTag;
        @Generated
        private Relay relay;

        @Generated
        AddressTagBuilder() {
        }

        @Generated
        public AddressTagBuilder kind(Integer kind) {
            this.kind = kind;
            return this;
        }

        @Generated
        public AddressTagBuilder publicKey(PublicKey publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        @Generated
        public AddressTagBuilder identifierTag(IdentifierTag identifierTag) {
            this.identifierTag = identifierTag;
            return this;
        }

        @Generated
        public AddressTagBuilder relay(Relay relay) {
            this.relay = relay;
            return this;
        }

        @Generated
        public AddressTag build() {
            return new AddressTag(this.kind, this.publicKey, this.identifierTag, this.relay);
        }

        @Generated
        public String toString() {
            return "AddressTag.AddressTagBuilder(kind=" + this.kind + ", publicKey=" + String.valueOf(this.publicKey) + ", identifierTag=" + String.valueOf(this.identifierTag) + ", relay=" + String.valueOf(this.relay) + ")";
        }
    }
}

