/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.tag;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Generated;
import lombok.NonNull;
import nostr.base.annotation.Key;
import nostr.base.annotation.Tag;
import nostr.event.BaseTag;
import nostr.event.json.serializer.ExpirationTagSerializer;
import nostr.event.tag.GenericTag;

@Tag(code="expiration", name="Expiration Timestamp", nip=40)
@JsonSerialize(using=ExpirationTagSerializer.class)
public class ExpirationTag
extends BaseTag {
    @Key
    @JsonProperty
    private Integer expiration;

    public static ExpirationTag deserialize(@NonNull JsonNode node) {
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        ExpirationTag tag = new ExpirationTag();
        ExpirationTag.setRequiredField(node.get(1), (n, t) -> tag.setExpiration(Integer.valueOf(n.asText())), tag);
        return tag;
    }

    public static ExpirationTag updateFields(@NonNull GenericTag tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        if (!"expiration".equals(tag.getCode())) {
            throw new IllegalArgumentException("Invalid tag code for ExpirationTag");
        }
        String expiration = tag.getAttributes().get(0).value().toString();
        return new ExpirationTag(Integer.parseInt(expiration));
    }

    @Generated
    public static ExpirationTagBuilder builder() {
        return new ExpirationTagBuilder();
    }

    @Generated
    public Integer getExpiration() {
        return this.expiration;
    }

    @Generated
    public void setExpiration(Integer expiration) {
        this.expiration = expiration;
    }

    @Override
    @Generated
    public String toString() {
        return "ExpirationTag(expiration=" + this.getExpiration() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExpirationTag)) {
            return false;
        }
        ExpirationTag other = (ExpirationTag)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$expiration = this.getExpiration();
        Integer other$expiration = other.getExpiration();
        return !(this$expiration == null ? other$expiration != null : !((Object)this$expiration).equals(other$expiration));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExpirationTag;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $expiration = this.getExpiration();
        result = result * 59 + ($expiration == null ? 43 : ((Object)$expiration).hashCode());
        return result;
    }

    @Generated
    public ExpirationTag(Integer expiration) {
        this.expiration = expiration;
    }

    @Generated
    public ExpirationTag() {
    }

    @Generated
    public static class ExpirationTagBuilder {
        @Generated
        private Integer expiration;

        @Generated
        ExpirationTagBuilder() {
        }

        @JsonProperty
        @Generated
        public ExpirationTagBuilder expiration(Integer expiration) {
            this.expiration = expiration;
            return this;
        }

        @Generated
        public ExpirationTag build() {
            return new ExpirationTag(this.expiration);
        }

        @Generated
        public String toString() {
            return "ExpirationTag.ExpirationTagBuilder(expiration=" + this.expiration + ")";
        }
    }
}

