/*
 * Decompiled with CFR 0.152.
 */
package nostr.event.tag;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import nostr.base.ElementAttribute;
import nostr.base.Relay;
import nostr.base.annotation.Tag;
import nostr.event.BaseTag;
import nostr.event.json.serializer.RelaysTagSerializer;
import nostr.event.tag.GenericTag;

@Tag(code="relays", nip=57)
@JsonSerialize(using=RelaysTagSerializer.class)
public class RelaysTag
extends BaseTag {
    private final List<Relay> relays;

    public RelaysTag() {
        this.relays = new ArrayList<Relay>();
    }

    public RelaysTag(@NonNull List<Relay> relays) {
        if (relays == null) {
            throw new NullPointerException("relays is marked non-null but is null");
        }
        this.relays = relays;
    }

    public RelaysTag(Relay ... relays) {
        this(List.of(relays));
        if (relays == null) {
            throw new NullPointerException("relays is marked non-null but is null");
        }
    }

    public static RelaysTag deserialize(JsonNode node) {
        return new RelaysTag(Optional.ofNullable(node).map(jsonNode -> new Relay(jsonNode.get(1).asText())).orElseThrow());
    }

    public static RelaysTag updateFields(@NonNull GenericTag genericTag) {
        if (genericTag == null) {
            throw new NullPointerException("genericTag is marked non-null but is null");
        }
        if (!"relays".equals(genericTag.getCode())) {
            throw new IllegalArgumentException("Invalid tag code for RelaysTag");
        }
        ArrayList<Relay> relays = new ArrayList<Relay>();
        for (ElementAttribute attribute : genericTag.getAttributes()) {
            relays.add(new Relay(attribute.value().toString()));
        }
        return new RelaysTag(relays);
    }

    @Generated
    public static RelaysTagBuilder builder() {
        return new RelaysTagBuilder();
    }

    @Generated
    public List<Relay> getRelays() {
        return this.relays;
    }

    @Override
    @Generated
    public String toString() {
        return "RelaysTag(relays=" + String.valueOf(this.getRelays()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RelaysTag)) {
            return false;
        }
        RelaysTag other = (RelaysTag)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<Relay> this$relays = this.getRelays();
        List<Relay> other$relays = other.getRelays();
        return !(this$relays == null ? other$relays != null : !((Object)this$relays).equals(other$relays));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RelaysTag;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<Relay> $relays = this.getRelays();
        result = result * 59 + ($relays == null ? 43 : ((Object)$relays).hashCode());
        return result;
    }

    @Generated
    public static class RelaysTagBuilder {
        @Generated
        private List<Relay> relays;

        @Generated
        RelaysTagBuilder() {
        }

        @Generated
        public RelaysTagBuilder relays(List<Relay> relays) {
            this.relays = relays;
            return this;
        }

        @Generated
        public RelaysTag build() {
            return new RelaysTag(this.relays);
        }

        @Generated
        public String toString() {
            return "RelaysTag.RelaysTagBuilder(relays=" + String.valueOf(this.relays) + ")";
        }
    }
}

