/*
 * Decompiled with CFR 0.152.
 */
package nostr.examples;

import java.util.List;
import java.util.Map;
import nostr.api.NIP01;
import nostr.base.Kind;
import nostr.base.PublicKey;
import nostr.event.BaseMessage;
import nostr.event.filter.AuthorFilter;
import nostr.event.filter.Filterable;
import nostr.event.filter.Filters;
import nostr.event.filter.KindFilter;
import nostr.event.json.codec.BaseMessageDecoder;
import nostr.event.message.EventMessage;
import nostr.id.Identity;

public class FilterExample {
    private static final String RELAY_URL = "wss://relay.damus.io";

    public static void main(String[] args) throws Exception {
        PublicKey author = new PublicKey("21ef0d8541375ae4bca85285097fba370f7e540b5a30e5e75670c16679f9d144");
        Filters filters = new Filters(new Filterable[]{new AuthorFilter(author), new KindFilter(Kind.TEXT_NOTE)});
        String subId = "filter-example-" + System.currentTimeMillis();
        Identity sender = Identity.generateRandomIdentity();
        NIP01 client = new NIP01(sender);
        client.setRelays(Map.of("damus", RELAY_URL));
        List responses = client.sendRequest(filters, subId);
        BaseMessageDecoder decoder = new BaseMessageDecoder();
        for (String json : responses) {
            BaseMessage message = decoder.decode(json);
            if (!(message instanceof EventMessage)) continue;
            EventMessage eventMessage = (EventMessage)message;
            System.out.println(eventMessage.getEvent());
        }
        client.close();
    }
}

