/*
 * Decompiled with CFR 0.152.
 */
package nostr.examples;

import java.time.Instant;
import java.util.List;
import nostr.base.ElementAttribute;
import nostr.base.IEvent;
import nostr.base.ISignable;
import nostr.base.Kind;
import nostr.client.springwebsocket.SpringWebSocketClient;
import nostr.client.springwebsocket.StandardWebSocketClient;
import nostr.client.springwebsocket.WebSocketClientIF;
import nostr.event.BaseMessage;
import nostr.event.impl.GenericEvent;
import nostr.event.message.EventMessage;
import nostr.event.tag.GenericTag;
import nostr.id.Identity;

public class ExpirationEventExample {
    private static final String RELAY_URI = "ws://localhost:5555";
    private static final long EXPIRATION_SECONDS = 3600L;

    private static GenericEvent createExpirationEvent() {
        Identity identity = Identity.generateRandomIdentity();
        long expiration = Instant.now().plusSeconds(3600L).getEpochSecond();
        GenericTag expirationTag = new GenericTag("expiration", new ElementAttribute[]{new ElementAttribute("param0", (Object)String.valueOf(expiration))});
        GenericEvent event = new GenericEvent(identity.getPublicKey(), Kind.TEXT_NOTE, List.of(expirationTag), "This message will expire at the specified timestamp and be deleted by relays.\n");
        identity.sign((ISignable)event);
        return event;
    }

    private static void sendWithStandardClient(GenericEvent event) throws Exception {
        try (StandardWebSocketClient client = new StandardWebSocketClient(RELAY_URI);){
            client.send((BaseMessage)new EventMessage((IEvent)event));
        }
    }

    private static void sendWithSpringClient(GenericEvent event) throws Exception {
        try (SpringWebSocketClient client = new SpringWebSocketClient((WebSocketClientIF)new StandardWebSocketClient(RELAY_URI), RELAY_URI);){
            client.send((BaseMessage)new EventMessage((IEvent)event));
        }
    }

    public static void main(String[] args) throws Exception {
        GenericEvent event = ExpirationEventExample.createExpirationEvent();
        ExpirationEventExample.sendWithSpringClient(event);
    }
}

