/*
 * Decompiled with CFR 0.152.
 */
package nostr.examples;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import nostr.api.NIP01;
import nostr.api.NIP04;
import nostr.api.NIP05;
import nostr.api.NIP09;
import nostr.api.NIP25;
import nostr.api.NIP28;
import nostr.api.NIP30;
import nostr.api.NostrIF;
import nostr.base.Kind;
import nostr.base.PublicKey;
import nostr.base.Relay;
import nostr.event.BaseTag;
import nostr.event.Deleteable;
import nostr.event.entities.ChannelProfile;
import nostr.event.entities.Reaction;
import nostr.event.entities.UserProfile;
import nostr.event.filter.AuthorFilter;
import nostr.event.filter.Filterable;
import nostr.event.filter.Filters;
import nostr.event.filter.KindFilter;
import nostr.event.filter.SinceFilter;
import nostr.event.impl.GenericEvent;
import nostr.event.tag.PubKeyTag;
import nostr.id.Identity;

public class NostrApiExamples {
    private static final Identity RECIPIENT = Identity.generateRandomIdentity();
    private static final Identity SENDER = Identity.generateRandomIdentity();
    private static final UserProfile PROFILE = new UserProfile(SENDER.getPublicKey(), "Nostr Guy", "guy@nostr-java.io", "It's me!", null);
    private static final Map<String, String> RELAYS = Map.of("local", "localhost:5555");

    public static void main(String[] args) throws Exception {
        new NostrApiExamples().run();
    }

    public void run() throws Exception {
        NostrApiExamples.logAccountsData();
        NostrApiExamples.metaDataEvent();
        NostrApiExamples.sendTextNoteEvent();
        NostrApiExamples.sendEncryptedDirectMessage();
        NostrApiExamples.deletionEvent();
        NostrApiExamples.ephemerealEvent();
        NostrApiExamples.reactionEvent();
        NostrApiExamples.replaceableEvent();
        NostrApiExamples.internetIdMetadata();
        NostrApiExamples.filters();
        NostrApiExamples.createChannel();
        NostrApiExamples.updateChannelMetadata();
        NostrApiExamples.sendChannelMessage();
        NostrApiExamples.hideMessage();
        NostrApiExamples.muteUser();
    }

    private static GenericEvent sendTextNoteEvent() {
        NostrApiExamples.logHeader("sendTextNoteEvent");
        ArrayList<PubKeyTag> tags = new ArrayList<PubKeyTag>(List.of(new PubKeyTag(RECIPIENT.getPublicKey())));
        NIP01 nip01 = new NIP01(SENDER);
        nip01.createTextNoteEvent(tags, "Hello world, I'm here on nostr-java API!").sign().send(RELAYS);
        return nip01.getEvent();
    }

    private static void sendEncryptedDirectMessage() {
        NostrApiExamples.logHeader("sendEncryptedDirectMessage");
        NIP04 nip04 = new NIP04(SENDER, RECIPIENT.getPublicKey());
        nip04.createDirectMessageEvent("Hello Nakamoto!").sign().send(RELAYS);
    }

    private static void deletionEvent() {
        NostrApiExamples.logHeader("deletionEvent");
        GenericEvent event = NostrApiExamples.sendTextNoteEvent();
        NIP09 nip09 = new NIP09(SENDER);
        nip09.createDeletionEvent(new Deleteable[]{event}).sign().send();
    }

    private static GenericEvent metaDataEvent() {
        NostrApiExamples.logHeader("metaDataEvent");
        NIP01 nip01 = new NIP01(SENDER);
        nip01.createMetadataEvent(PROFILE).sign().send(RELAYS);
        return nip01.getEvent();
    }

    private static void ephemerealEvent() {
        NostrApiExamples.logHeader("ephemeralEvent");
        NIP01 nip01 = new NIP01(SENDER);
        nip01.createEphemeralEvent(Integer.valueOf(Kind.EPHEMEREAL_EVENT.getValue()), "An ephemeral event").sign().send(RELAYS);
    }

    private static void reactionEvent() {
        NostrApiExamples.logHeader("reactionEvent");
        ArrayList<BaseTag> tags = new ArrayList<BaseTag>(List.of(NIP30.createEmojiTag((String)"soapbox", (String)"https://gleasonator.com/emoji/Gleasonator/soapbox.png")));
        NIP01 nip01 = new NIP01(SENDER);
        NIP01 event = nip01.createTextNoteEvent(tags, "Hello Astral, Please like me! :soapbox:");
        event.signAndSend(RELAYS);
        NIP25 nip25 = new NIP25(RECIPIENT);
        NIP25 reactionEvent = nip25.createReactionEvent(event.getEvent(), Reaction.LIKE, new Relay("localhost:5555"));
        reactionEvent.signAndSend(RELAYS);
        nip25.createReactionEvent(event.getEvent(), "\ud83d\udca9", new Relay("localhost:5555")).signAndSend();
        BaseTag eventTag = NIP01.createEventTag((String)event.getEvent().getId());
        nip25.createReactionEvent(eventTag, NIP30.createEmojiTag((String)"ablobcatrainbow", (String)"https://gleasonator.com/emoji/blobcat/ablobcatrainbow.png")).signAndSend();
    }

    private static void replaceableEvent() {
        NostrApiExamples.logHeader("replaceableEvent");
        NIP01 nip01 = new NIP01(SENDER);
        NIP01 event = nip01.createTextNoteEvent("Hello Astral, Please replace me!");
        event.signAndSend(RELAYS);
        nip01.createReplaceableEvent(List.of(NIP01.createEventTag((String)event.getEvent().getId())), Integer.valueOf(Kind.REPLACEABLE_EVENT.getValue()), "New content").signAndSend();
    }

    private static void internetIdMetadata() {
        NostrApiExamples.logHeader("internetIdMetadata");
        UserProfile profile = ((UserProfile.UserProfileBuilder)UserProfile.builder().name("Guilherme Gps")).publicKey(new PublicKey("21ef0d8541375ae4bca85285097fba370f7e540b5a30e5e75670c16679f9d144")).nip05("me@guilhermegps.com.br").build();
        NIP05 nip05 = new NIP05(SENDER);
        nip05.createInternetIdentifierMetadataEvent(profile).sign().send(RELAYS);
    }

    private static void filters() throws InterruptedException {
        NostrApiExamples.logHeader("filters");
        Calendar date = Calendar.getInstance();
        String subId = "subId" + date.getTimeInMillis();
        date.add(5, -5);
        NostrIF nip01 = NIP01.getInstance();
        nip01.setRelays(RELAYS).sendRequest(new Filters(new Filterable[]{new KindFilter(Kind.EPHEMEREAL_EVENT), new KindFilter(Kind.TEXT_NOTE), new AuthorFilter(new PublicKey("21ef0d8541375ae4bca85285097fba370f7e540b5a30e5e75670c16679f9d144")), new SinceFilter(Long.valueOf(date.getTimeInMillis() / 1000L))}), subId);
        Thread.sleep(5000L);
    }

    private static GenericEvent createChannel() {
        try {
            NostrApiExamples.logHeader("createChannel");
            ChannelProfile channel = new ChannelProfile("JNostr Channel", "This is a channel to test NIP28 in nostr-java", "https://cdn.pixabay.com/photo/2020/05/19/13/48/cartoon-5190942_960_720.jpg");
            NIP28 nip28 = new NIP28(SENDER);
            nip28.setSender(SENDER);
            nip28.createChannelCreateEvent(channel).sign().send();
            return nip28.getEvent();
        }
        catch (MalformedURLException | URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void updateChannelMetadata() {
        try {
            NostrApiExamples.logHeader("updateChannelMetadata");
            GenericEvent channelCreateEvent = NostrApiExamples.createChannel();
            ChannelProfile channel = new ChannelProfile("test change name", "This is a channel to test NIP28 in nostr-java | changed", "https://cdn.pixabay.com/photo/2020/05/19/13/48/cartoon-5190942_960_720.jpg");
            NIP28 nip28 = new NIP28(SENDER);
            nip28.updateChannelMetadataEvent(channelCreateEvent, channel, null).sign().send();
        }
        catch (MalformedURLException | URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static GenericEvent sendChannelMessage() {
        NostrApiExamples.logHeader("sendChannelMessage");
        GenericEvent channelCreateEvent = NostrApiExamples.createChannel();
        NIP28 nip28 = new NIP28(SENDER);
        nip28.createChannelMessageEvent(channelCreateEvent, new Relay("localhost:5555"), "Hello everybody!").sign().send();
        return nip28.getEvent();
    }

    private static GenericEvent hideMessage() {
        NostrApiExamples.logHeader("hideMessage");
        GenericEvent channelMessageEvent = NostrApiExamples.sendChannelMessage();
        NIP28 nip28 = new NIP28(SENDER);
        nip28.createHideMessageEvent(channelMessageEvent, "Dick pic").sign().send();
        return nip28.getEvent();
    }

    private static GenericEvent muteUser() {
        NostrApiExamples.logHeader("muteUser");
        NIP28 nip28 = new NIP28(SENDER);
        nip28.createMuteUserEvent(RECIPIENT.getPublicKey(), "Posting dick pics").sign().send();
        return nip28.getEvent();
    }

    private static void logAccountsData() {
        String msg = "################################ ACCOUNTS BEGINNING ################################\n*** RECEIVER ***\n\n* PrivateKey: " + RECIPIENT.getPrivateKey().toBech32String() + "\n* PrivateKey HEX: " + RECIPIENT.getPrivateKey().toString() + "\n* PublicKey: " + RECIPIENT.getPublicKey().toBech32String() + "\n* PublicKey HEX: " + RECIPIENT.getPublicKey().toString() + "\n\n*** SENDER ***\n\n* PrivateKey: " + SENDER.getPrivateKey().toBech32String() + "\n* PrivateKey HEX: " + SENDER.getPrivateKey().toString() + "\n* PublicKey: " + SENDER.getPublicKey().toBech32String() + "\n* PublicKey HEX: " + SENDER.getPublicKey().toString() + "\n\n################################ ACCOUNTS END ################################";
        System.out.println(msg);
    }

    private static void logHeader(String header) {
        int i;
        for (i = 0; i < 30; ++i) {
            System.out.print("#");
        }
        System.out.println();
        System.out.println("\t" + header);
        for (i = 0; i < 30; ++i) {
            System.out.print("#");
        }
        System.out.println();
    }

    static {
        try {
            PROFILE.setPicture(new URI("https://images.unsplash.com/photo-1462888210965-cdf193fb74de").toURL());
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

