/*
 * Decompiled with CFR 0.152.
 */
package nostr.examples;

import java.time.Duration;
import java.util.Map;
import nostr.api.NostrSpringWebSocketClient;
import nostr.base.Kind;
import nostr.event.filter.Filterable;
import nostr.event.filter.Filters;
import nostr.event.filter.KindFilter;

public class SpringSubscriptionExample {
    private static final Map<String, String> RELAYS = Map.of("local", "ws://localhost:5555");
    private static final Duration LISTEN_DURATION = Duration.ofSeconds(30L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        NostrSpringWebSocketClient client = new NostrSpringWebSocketClient();
        client.setRelays(RELAYS);
        Filters filters = new Filters(new Filterable[]{new KindFilter(Kind.TEXT_NOTE)});
        AutoCloseable subscription = client.subscribe(filters, "example-subscription", message -> System.out.printf("Received from relay: %s%n", message), error -> System.err.printf("Subscription error for %s: %s%n", RELAYS.keySet(), error.getMessage()));
        try {
            System.out.printf("Listening for %d seconds. Publish events to %s to see them here.%n", LISTEN_DURATION.toSeconds(), RELAYS.values());
            Thread.sleep(LISTEN_DURATION.toMillis());
        }
        finally {
            try {
                subscription.close();
            }
            finally {
                client.close();
            }
        }
    }
}

