/*
 * Decompiled with CFR 0.152.
 */
package nostr.id;

import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.util.function.Consumer;
import lombok.Generated;
import lombok.NonNull;
import nostr.base.ISignable;
import nostr.base.PrivateKey;
import nostr.base.PublicKey;
import nostr.base.Signature;
import nostr.crypto.schnorr.Schnorr;
import nostr.crypto.schnorr.SchnorrException;
import nostr.id.SigningException;
import nostr.util.NostrUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Identity {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Identity.class);
    private final PrivateKey privateKey;
    private PublicKey cachedPublicKey;

    private Identity(@NonNull PrivateKey privateKey) {
        if (privateKey == null) {
            throw new NullPointerException("privateKey is marked non-null but is null");
        }
        this.privateKey = privateKey;
    }

    public static Identity create(@NonNull PrivateKey privateKey) {
        if (privateKey == null) {
            throw new NullPointerException("privateKey is marked non-null but is null");
        }
        return new Identity(privateKey);
    }

    public static Identity create(@NonNull String privateKey) {
        if (privateKey == null) {
            throw new NullPointerException("privateKey is marked non-null but is null");
        }
        return new Identity(new PrivateKey(privateKey));
    }

    public static Identity generateRandomIdentity() {
        return new Identity(PrivateKey.generateRandomPrivKey());
    }

    public PublicKey getPublicKey() {
        if (this.cachedPublicKey == null) {
            try {
                this.cachedPublicKey = new PublicKey(Schnorr.genPubKey((byte[])this.getPrivateKey().getRawData()));
            }
            catch (IllegalArgumentException ex) {
                log.error("Invalid private key while deriving public key", (Throwable)ex);
                throw new IllegalStateException("Invalid private key", ex);
            }
            catch (SchnorrException ex) {
                log.error("Failed to derive public key", (Throwable)ex);
                throw new IllegalStateException("Failed to derive public key", ex);
            }
        }
        return this.cachedPublicKey;
    }

    public Signature sign(@NonNull ISignable signable) {
        if (signable == null) {
            throw new NullPointerException("signable is marked non-null but is null");
        }
        try {
            Signature signature = new Signature();
            signature.setRawData(Schnorr.sign((byte[])NostrUtil.sha256((byte[])((ByteBuffer)signable.getByteArraySupplier().get()).array()), (byte[])this.getPrivateKey().getRawData(), (byte[])this.generateAuxRand()));
            signature.setPubKey(this.getPublicKey());
            Consumer consumer = signable.getSignatureConsumer();
            if (consumer != null) {
                consumer.accept(signature);
            }
            return signature;
        }
        catch (NoSuchAlgorithmException ex) {
            log.error("SHA-256 algorithm not available for signing", (Throwable)ex);
            throw new IllegalStateException("SHA-256 algorithm not available", ex);
        }
        catch (IllegalArgumentException ex) {
            log.error("Invalid signing input", (Throwable)ex);
            throw new SigningException("Failed to sign because of invalid input", ex);
        }
        catch (SchnorrException ex) {
            log.error("Signing failed", (Throwable)ex);
            throw new SigningException("Failed to sign with provided key", ex);
        }
    }

    private byte[] generateAuxRand() {
        return NostrUtil.createRandomByteArray((int)32);
    }

    @Generated
    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @Generated
    public PublicKey getCachedPublicKey() {
        return this.cachedPublicKey;
    }

    @Generated
    public void setCachedPublicKey(PublicKey cachedPublicKey) {
        this.cachedPublicKey = cachedPublicKey;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Identity)) {
            return false;
        }
        Identity other = (Identity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PrivateKey this$privateKey = this.getPrivateKey();
        PrivateKey other$privateKey = other.getPrivateKey();
        if (this$privateKey == null ? other$privateKey != null : !this$privateKey.equals(other$privateKey)) {
            return false;
        }
        PublicKey this$cachedPublicKey = this.getCachedPublicKey();
        PublicKey other$cachedPublicKey = other.getCachedPublicKey();
        return !(this$cachedPublicKey == null ? other$cachedPublicKey != null : !this$cachedPublicKey.equals(other$cachedPublicKey));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Identity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PrivateKey $privateKey = this.getPrivateKey();
        result = result * 59 + ($privateKey == null ? 43 : $privateKey.hashCode());
        PublicKey $cachedPublicKey = this.getCachedPublicKey();
        result = result * 59 + ($cachedPublicKey == null ? 43 : $cachedPublicKey.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Identity()";
    }
}

