/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.phoenixd.common.rest.util;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Configuration.class);
    @NonNull
    private final String prefix;
    private final Properties properties;

    private String envKey(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return (this.prefix + "_" + key).toUpperCase().replace('.', '_');
    }

    private String envValue(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        String value = System.getenv(this.envKey(key));
        return value == null || value.isEmpty() ? null : value;
    }

    private String resolve(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        String env = this.envValue(key);
        if (env != null) {
            if (log.isDebugEnabled()) {
                log.debug("Config '{}' resolved from ENV", (Object)key);
            }
            return env;
        }
        String sys = System.getProperty(this.prefix + "." + key);
        if (sys != null && !sys.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug("Config '{}' resolved from system properties", (Object)key);
            }
            return sys;
        }
        String fileVal = this.properties.getProperty(this.prefix + "." + key);
        if (fileVal != null && log.isDebugEnabled()) {
            log.debug("Config '{}' resolved from app.properties", (Object)key);
        }
        return fileVal;
    }

    public Configuration(@NonNull String prefix, @NonNull URL fileUrl) {
        if (prefix == null) {
            throw new NullPointerException("prefix is marked non-null but is null");
        }
        if (fileUrl == null) {
            throw new NullPointerException("fileUrl is marked non-null but is null");
        }
        this.prefix = prefix;
        this.properties = new Properties();
        try (InputStream in = fileUrl.openStream();){
            if (in != null) {
                this.properties.load(in);
            }
        }
    }

    public Configuration(@NonNull String prefix) {
        URL resource;
        if (prefix == null) {
            throw new NullPointerException("prefix is marked non-null but is null");
        }
        this.prefix = prefix;
        this.properties = new Properties();
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        URL uRL = resource = tccl != null ? tccl.getResource("app.properties") : null;
        if (resource == null) {
            resource = this.getClass().getResource("/app.properties");
        }
        if (resource != null) {
            try (InputStream in = resource.openStream();){
                if (in != null) {
                    this.properties.load(in);
                    if (log.isInfoEnabled()) {
                        log.info("Loaded configuration from '{}'", (Object)resource);
                    }
                }
            }
        }
        if (this.properties.isEmpty()) {
            log.warn("No app.properties found on classpath; relying on ENV and system properties only");
        }
    }

    public List<String> keys() {
        ArrayList<String> result = new ArrayList<String>();
        Set<String> names = this.properties.stringPropertyNames();
        String prefixDot = this.prefix + ".";
        for (String key : names) {
            if (!key.startsWith(prefixDot)) continue;
            result.add(key.substring(prefixDot.length()));
        }
        return result;
    }

    public String get(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.resolve(key);
    }

    public int getInt(@NonNull String key, int defaultValue) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        String value = this.resolve(key);
        return value != null ? Integer.parseInt(value) : defaultValue;
    }

    public Long getLong(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        String value = this.resolve(key);
        return value != null ? Long.valueOf(value) : Long.MIN_VALUE;
    }

    public Long getLong(@NonNull String key, Long defaultValue) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        String value = this.resolve(key);
        return value != null ? Long.valueOf(value) : defaultValue;
    }

    public Double getDouble(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        String value = this.resolve(key);
        return value != null ? Double.valueOf(value) : Double.MIN_VALUE;
    }

    public Double getDouble(@NonNull String key, Double defaultValue) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        String value = this.resolve(key);
        return value != null ? Double.valueOf(value) : defaultValue;
    }

    public Integer getInt(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        String value = this.resolve(key);
        return value != null ? Integer.valueOf(value) : Integer.MIN_VALUE;
    }

    public boolean getBoolean(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        String value = this.resolve(key);
        return value != null ? Boolean.parseBoolean(value) : false;
    }

    public String get(@NonNull String key, @NonNull String defaultValue) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        String value = this.resolve(key);
        return value != null ? value : defaultValue;
    }

    public boolean getBoolean(@NonNull String key, boolean defaultValue) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        String value = this.resolve(key);
        return value != null ? Boolean.parseBoolean(value) : defaultValue;
    }

    @Generated
    public Configuration(@NonNull String prefix, Properties properties) {
        if (prefix == null) {
            throw new NullPointerException("prefix is marked non-null but is null");
        }
        this.prefix = prefix;
        this.properties = properties;
    }

    @NonNull
    @Generated
    public String getPrefix() {
        return this.prefix;
    }

    @Generated
    public Properties getProperties() {
        return this.properties;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Configuration)) {
            return false;
        }
        Configuration other = (Configuration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$prefix = this.getPrefix();
        String other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        Properties this$properties = this.getProperties();
        Properties other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Configuration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        Properties $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Configuration(prefix=" + this.getPrefix() + ", properties=" + String.valueOf(this.getProperties()) + ")";
    }
}

