/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.phoenixd.mock;

import java.io.IOException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.phoenixd.mock.MockLnServer;

public class Main {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Main.class);

    public static void main(String[] args) throws IOException {
        int port = Main.getPort();
        if (port < 1024 || port > 65535) {
            log.error("Invalid port: {}. Expected range: 1024..65535", (Object)port);
            System.exit(1);
        }
        MockLnServer server = new MockLnServer(port);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                log.info("Shutdown signal received. Stopping server on port {}...", (Object)port);
                server.stop();
                log.info("Server stopped.");
            }
            catch (Throwable t) {
                log.error("Error while stopping server", t);
            }
        }, "shutdown-hook"));
        server.start();
    }

    private static int getPort() {
        String port = System.getenv("phoenixd_mock_port");
        if (port == null || port.isEmpty()) {
            return 9740;
        }
        try {
            return Integer.parseInt(port);
        }
        catch (NumberFormatException e) {
            return 9740;
        }
    }
}

