/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.phoenixd.mock;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import lombok.Generated;

public class MockLnServer {
    private HttpServer server;
    private final int port;

    public void start() throws IOException {
        this.server = HttpServer.create(new InetSocketAddress(this.port), 0);
        this.server.createContext("/getlnaddress", this::handleGetLightningAddress);
        this.server.createContext("/paylnaddress", this::handlePayLightningAddress);
        this.server.createContext("/createinvoice", this::handleCreateInvoice);
        this.server.createContext("/decodeinvoice", this::handleDecodeInvoice);
        this.server.createContext("/delete", this::handleDelete);
        this.server.createContext("/patch", this::handlePatch);
        this.server.setExecutor(null);
        this.server.start();
    }

    public void stop() {
        if (this.server != null) {
            this.server.stop(0);
            this.server = null;
        }
    }

    private void handleGetLightningAddress(HttpExchange exchange) throws IOException {
        this.writeString(exchange, "\u20bf398ja@strike.me");
    }

    private void handlePayLightningAddress(HttpExchange exchange) throws IOException {
        this.writeJson(exchange, "{\"recipientAmountSat\":10}");
    }

    private void handleCreateInvoice(HttpExchange exchange) throws IOException {
        this.writeJson(exchange, "{\"amountSat\":10,\"paymentHash\":\"hash\",\"serialized\":\"invoice\"}");
    }

    private void handleDecodeInvoice(HttpExchange exchange) throws IOException {
        this.writeJson(exchange, "{\"amount\":1000,\"description\":\"1 Blockaccino\"}");
    }

    private void handleDelete(HttpExchange exchange) throws IOException {
        this.writeJson(exchange, "{\"status\":\"deleted\"}");
    }

    private void handlePatch(HttpExchange exchange) throws IOException {
        this.writeJson(exchange, "{\"status\":\"patched\"}");
    }

    private void writeJson(HttpExchange exchange, String json) throws IOException {
        exchange.getResponseHeaders().add("Content-Type", "application/json");
        this.writeString(exchange, json);
    }

    private void writeString(HttpExchange exchange, String body) throws IOException {
        byte[] bytes = body.getBytes(StandardCharsets.UTF_8);
        exchange.sendResponseHeaders(200, bytes.length);
        try (OutputStream os = exchange.getResponseBody();){
            os.write(bytes);
        }
    }

    @Generated
    public MockLnServer(int port) {
        this.port = port;
    }
}

